/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.generator.digit;

import com.oceanbase.tools.datamocker.generator.BaseDigitalGenerator;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import com.oceanbase.tools.datamocker.util.Range;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class RangeGenerator
extends BaseDigitalGenerator<BigDecimal> {
    private final Map<Range<BigDecimal>, Double> weightMap;

    public RangeGenerator(Map<Range<BigDecimal>, Double> weightMap) {
        this.weightMap = weightMap;
        if (weightMap == null) {
            throw new MockerException("Weight map can not be null");
        }
        Set<Range<BigDecimal>> keySet = weightMap.keySet();
        Iterator<Range<BigDecimal>> iter = keySet.iterator();
        Double result = 0.0;
        while (iter.hasNext()) {
            Range<BigDecimal> key = iter.next();
            result = result + weightMap.get(key);
        }
        if (result <= 1.0 && Math.abs(result - 1.0) > 0.01) {
            throw new MockerException("Weight values have to be added to one");
        }
    }

    @Override
    public Boolean preCheck(BigDecimal minValue, BigDecimal maxValue) {
        Boolean validate = null;
        Set<Range<BigDecimal>> keySet = this.weightMap.keySet();
        for (Range<BigDecimal> key : keySet) {
            if (key.getMin().compareTo(minValue) < 0) {
                validate = false;
                continue;
            }
            if (key.getMax().compareTo(maxValue) > 0) {
                validate = false;
                continue;
            }
            if (validate != null && !validate.booleanValue()) continue;
            validate = true;
        }
        if (validate == null) {
            throw new MockerException(MockerError.VALUE_OUT_OFRANGE, "Input range info is illegal");
        }
        if (!validate.booleanValue()) {
            throw new MockerException(MockerError.VALUE_OUT_OFRANGE, "Input range info is illegal");
        }
        return true;
    }

    @Override
    public BigDecimal generate(BigDecimal minValue, BigDecimal maxValue) {
        Range<BigDecimal> range = this.getRange();
        BigDecimal min = range.getMin();
        BigDecimal max = range.getMax();
        return new BigDecimal(Double.toString(Math.random())).multiply(max.subtract(min)).add(min);
    }

    private Range<BigDecimal> getRange() {
        double random = Math.random();
        Set<Range<BigDecimal>> keySet = this.weightMap.keySet();
        Iterator<Range<BigDecimal>> iter = keySet.iterator();
        Double sum = 0.0;
        Range<BigDecimal> returnValue = null;
        while (iter.hasNext()) {
            Range<BigDecimal> key = iter.next();
            if (sum > random) break;
            sum = sum + this.weightMap.get(key);
            returnValue = key;
        }
        return returnValue;
    }

    @Override
    public Long count(BigDecimal minValue, BigDecimal maxValue) {
        return null;
    }
}

