/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.model.config;

import com.oceanbase.tools.datamocker.constraint.AbstractConstraint;
import com.oceanbase.tools.datamocker.model.config.AbstractColumnConfig;
import com.oceanbase.tools.datamocker.model.enums.DuplicateStrategy;
import com.oceanbase.tools.datamocker.model.enums.ScriptType;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import java.util.List;

public abstract class AbstractTableConfig {
    protected abstract Long maxRowCount();

    public Long maxCount() {
        if (this.maxRowCount() == null) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Max count can not be null");
        }
        if (this.maxRowCount() < 0L) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Max count can not be smaller than zero");
        }
        if (this.maxRowCount() > 1000000L) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Max count can not be bigger than 1000000");
        }
        return this.maxRowCount();
    }

    @Deprecated
    public abstract DuplicateStrategy duplicateStrategy();

    protected abstract Long batchSize();

    public Long maxBatchSize() {
        if (this.batchSize() == null) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Batch size can not be null");
        }
        if (this.batchSize() < 0L) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Batch size can not be smaller than zero");
        }
        if (this.batchSize() > 100000L) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Batch size can not be bigger than 100000");
        }
        return this.batchSize();
    }

    public abstract Boolean truncated();

    public abstract String tableName();

    public abstract List<? extends AbstractColumnConfig> columns();

    public abstract String schemaName();

    public abstract Long timeoutMilliseconds();

    public abstract ScriptType[] scriptType();

    public abstract String dataWriteLocation(ScriptType var1);

    public abstract List<AbstractConstraint> constraints();

    public abstract int maxRetainedCount();
}

