/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.model.config;

import com.oceanbase.tools.datamocker.model.config.AbstractTableConfig;
import com.oceanbase.tools.datamocker.model.config.model.DataBaseConfig;
import com.oceanbase.tools.datamocker.model.enums.ObModeType;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import java.util.List;

public abstract class AbstractTaskConfig {
    public abstract ObModeType obDialectType();

    public abstract DataBaseConfig dbConfig();

    public abstract List<? extends AbstractTableConfig> tasks();

    public abstract String taskName();

    public int minConnection() {
        if (this.connectionInitCount() < 3) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Min connection count for connection pool can not be smaller than 3");
        }
        if (this.connectionInitCount() > this.connectionMaxCount()) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Min connection count can not bigger than max connection count");
        }
        return this.connectionInitCount();
    }

    public int maxConnection() {
        if (this.connectionMaxCount() < 5) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Max connection count for connection pool can not be smaller than 5");
        }
        if (this.connectionMaxCount() < this.connectionInitCount()) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Max connection count can not smaller than min connection count");
        }
        return this.connectionMaxCount();
    }

    public int connectionIncreasementStep() {
        if (this.connectionIncreaseStepCount() < 0) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Connection pool's increase step can not be smaller than zero");
        }
        return this.connectionIncreaseStepCount();
    }

    protected abstract int connectionIncreaseStepCount();

    protected abstract int connectionInitCount();

    protected abstract int connectionMaxCount();
}

