/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.model.mock;

import com.oceanbase.tools.datamocker.datatype.AbstractDataType;
import com.oceanbase.tools.datamocker.util.Pair;
import org.apache.commons.lang.Validate;

public class MockColumnData<T> {
    private final Pair<AbstractDataType<T, ? extends Comparable<?>>, T> column;
    private final String columnName;

    public MockColumnData(String columnName, AbstractDataType<T, ? extends Comparable<?>> dataType, T columnValue) {
        Validate.notEmpty((String)columnName, (String)"ColumnName can not be blank for MockColumn");
        Validate.notNull(dataType, (String)"DataType can not be null for MockColumn");
        this.column = new Pair(dataType, columnValue);
        this.columnName = columnName;
    }

    public T getColumnValue() {
        return this.column.getValue();
    }

    public Object getJdbcColumnValue() {
        return this.column.getKey().convertFromJavaObjectToJdbcObject(this.getColumnValue());
    }

    public String getColumnValueString() {
        return this.column.getKey().convertToSqlString(this.getColumnValue());
    }

    public AbstractDataType<T, ? extends Comparable<?>> getColumnDataType() {
        return this.column.getKey();
    }

    public T toDigest() {
        AbstractDataType<T, Comparable<?>> dataType = this.getColumnDataType();
        return dataType.toDigest(dataType.convertFromJdbcObjectToJavaObject(this.getColumnValue()));
    }

    public String toDisgestString() {
        return this.getColumnDataType().convertToSqlString(this.toDigest());
    }

    public String getColumnName() {
        return this.columnName;
    }
}

