/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.model.mock;

import com.oceanbase.tools.datamocker.model.mock.MockColumnData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.Validate;

public class MockRowData {
    private final Map<String, MockColumnData<?>> rowWithMultiColumn;

    public MockRowData(List<MockColumnData<?>> columnList) {
        Validate.notNull(columnList, (String)"ColumnList can not be null for MockRowData");
        this.rowWithMultiColumn = new HashMap(columnList.size());
        for (MockColumnData<?> columnItem : columnList) {
            this.rowWithMultiColumn.put(columnItem.getColumnName(), columnItem);
        }
    }

    public MockRowData() {
        this.rowWithMultiColumn = new HashMap();
    }

    public MockRowData(int rowWidth) {
        Validate.isTrue((rowWidth > 0 ? 1 : 0) != 0, (String)"Row width can not be negative for MockRowData");
        this.rowWithMultiColumn = new HashMap(rowWidth);
    }

    public MockColumnData<?> getMockColumn(String columnName) {
        Validate.notEmpty((String)columnName, (String)"ColumnName can not be blank for MockRowData#getMockColumn");
        return this.rowWithMultiColumn.get(columnName);
    }

    public MockColumnData<?> remove(MockColumnData<?> mockColumn) {
        Validate.notNull(mockColumn, (String)"MockColumn can not be null for MockRowData#remove");
        return this.rowWithMultiColumn.remove(mockColumn.getColumnName());
    }

    public MockColumnData<?> remove(String columnName) {
        Validate.notNull((Object)columnName, (String)"ColumnName can not be null for MockRowData#remove");
        return this.rowWithMultiColumn.remove(columnName);
    }

    public MockColumnData<?> addMockColumn(MockColumnData<?> mockColumn) {
        Validate.notNull(mockColumn, (String)"MockColumn can not be null for MockRowData#putIfAbsent");
        String columnName = mockColumn.getColumnName();
        return this.rowWithMultiColumn.putIfAbsent(columnName, mockColumn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int columnNum() {
        Map<String, MockColumnData<?>> map = this.rowWithMultiColumn;
        synchronized (map) {
            return this.rowWithMultiColumn.size();
        }
    }

    public Set<String> columnNames() {
        return this.rowWithMultiColumn.keySet();
    }

    public List<MockColumnData<?>> getMockColumns() {
        return this.rowWithMultiColumn.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }
}

