/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.schedule;

import com.oceanbase.tools.datamocker.core.task.AbstractCallBack;
import com.oceanbase.tools.datamocker.core.task.TableTaskContext;
import com.oceanbase.tools.datamocker.core.task.TableTaskMetaData;
import com.oceanbase.tools.datamocker.model.enums.MockTaskStatus;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class AbstractMockTask
implements Callable<Void> {
    private static final Logger log = LoggerFactory.getLogger(AbstractMockTask.class);
    private final long startTimeStamp;
    private AbstractCallBack<TableTaskContext> callBack;
    private final String taskId = UUID.randomUUID().toString();
    private final TableTaskMetaData metaData;
    private final TableTaskContext context;

    public AbstractMockTask(TableTaskMetaData metaData, TableTaskContext context) {
        this.metaData = metaData;
        this.startTimeStamp = System.currentTimeMillis();
        this.context = context;
    }

    public abstract void execute(TableTaskMetaData var1, TableTaskContext var2) throws Throwable;

    @Override
    public Void call() {
        try {
            MDC.put((String)"mocktask.workspace", (String)this.metaData.getTaskId());
            this.execute(this.metaData, this.context);
            if (this.callBack != null) {
                try {
                    this.callBack.onSuccess(this.context);
                }
                catch (Throwable e) {
                    boolean shutdownResult = this.context.terminate();
                    this.context.setStatus(MockTaskStatus.FAILED);
                    log.error("Some errors happened when onSuccess call back method executed, context has been shutdown. shutdownResult={},status={}", new Object[]{shutdownResult, "FAILED", e});
                }
            }
            return null;
        }
        catch (Throwable e) {
            log.error("Fail to execute mock data task", e);
            Throwable exception = e;
            while (!(exception instanceof InterruptedException) && (exception = exception.getCause()) != null) {
            }
            if (exception != null) {
                if (MockTaskStatus.CANCELED.equals((Object)this.context.getStatus())) {
                    log.warn("Mock data task is interrupted, duration={}ms,status={}", (Object)this.interval(), (Object)this.context.getStatus());
                } else {
                    this.context.setStatus(MockTaskStatus.FAILED);
                }
            } else if (!MockTaskStatus.CANCELED.equals((Object)this.context.getStatus())) {
                this.context.setStatus(MockTaskStatus.FAILED);
            }
            this.context.terminate();
            if (this.callBack != null) {
                MockTaskStatus finalStatus = this.context.getStatus();
                try {
                    this.callBack.onFailure(this.context, e);
                }
                catch (Throwable e1) {
                    log.error("Some errors happend when execute onFailure call back method. status={}", (Object)finalStatus, (Object)e);
                }
                this.context.setStatus(finalStatus);
            }
            return null;
        }
    }

    public void bind(AbstractCallBack<TableTaskContext> callBack) {
        this.callBack = callBack;
    }

    protected long interval() {
        return System.currentTimeMillis() - this.startTimeStamp;
    }

    protected long startTime() {
        return this.startTimeStamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractMockTask that = (AbstractMockTask)o;
        return this.taskId == that.taskId;
    }

    public int hashCode() {
        return this.taskId.hashCode();
    }
}

