/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.schedule;

import com.oceanbase.tools.datamocker.core.task.TableTaskContext;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import com.oceanbase.tools.datamocker.schedule.MockExecutorService;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class MockContext {
    private final Integer totalTableTaskCount;
    private final String taskName;
    private final String taskId;
    private final List<TableTaskContext> tables;
    private final MockExecutorService service;

    public MockContext(MockExecutorService service, String taskId, String taskName, Integer totalTableTaskCount) {
        this.taskId = taskId;
        this.taskName = taskName;
        this.totalTableTaskCount = totalTableTaskCount;
        this.tables = new LinkedList<TableTaskContext>();
        if (service == null) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Thread pool for schedule context can not be null");
        }
        this.service = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void appendContext(TableTaskContext context) {
        if (context == null) {
            return;
        }
        List<TableTaskContext> list = this.tables;
        synchronized (list) {
            this.tables.add(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<TableTaskContext> removeContext(String taskId) {
        if (taskId == null) {
            return Collections.emptyList();
        }
        LinkedList<TableTaskContext> returnVal = new LinkedList<TableTaskContext>();
        List<TableTaskContext> list = this.tables;
        synchronized (list) {
            int length = this.tables.size();
            for (int i = 0; i < length; ++i) {
                if (!taskId.equals(this.tables.get(i).getTableTaskId())) continue;
                returnVal.add(this.tables.remove(i));
                --length;
            }
        }
        return returnVal;
    }

    public Boolean shutdown() {
        this.service.shutdown();
        boolean returnVal = true;
        for (TableTaskContext context : this.tables) {
            returnVal &= context.shutdown();
        }
        return returnVal;
    }

    public double getProgress() {
        if (this.tables.size() != 0) {
            double returnVal = 0.0;
            for (TableTaskContext context : this.tables) {
                returnVal += context.getProgress();
            }
            BigDecimal decaimal = new BigDecimal(returnVal * 100.0 / (double)this.totalTableTaskCount.intValue());
            return decaimal.setScale(2, 4).doubleValue();
        }
        return 0.0;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public List<TableTaskContext> getTables() {
        return this.tables;
    }
}

