/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.schedule;

import com.oceanbase.tools.datamocker.core.task.TableTask;
import com.oceanbase.tools.datamocker.core.task.TableTaskContext;
import com.oceanbase.tools.datamocker.model.enums.MockTaskStatus;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadPoolExecutor;

public class MockExecutorService {
    private final ThreadPoolExecutor executor;

    public MockExecutorService(ThreadPoolExecutor executor) {
        if (executor == null) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Executor for mock executor service can not be null");
        }
        this.executor = executor;
    }

    private <V> RunnableFuture<V> newTaskFor(Callable<V> task) {
        return new FutureTask<V>(task);
    }

    private <V> RunnableFuture<V> newTaskFor(Runnable task, V result) {
        return new FutureTask<V>(task, result);
    }

    public synchronized TableTaskContext submit(TableTask taskBean) {
        if (taskBean == null) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Task bean for executor service can not be null");
        }
        taskBean.getContext().setStatus(MockTaskStatus.RUNNING);
        this.submitCallable(taskBean.getBeforeTask(), taskBean.getContext());
        return taskBean.getContext();
    }

    public synchronized <V> void submitCallable(Callable<V> task, TableTaskContext context) {
        if (task == null || context == null) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Callable or context for executor service can not be null");
        }
        if (!context.isShutdown() && !this.isShutdown()) {
            Future<?> future = this.executor.submit(this.newTaskFor(task));
            context.appendHandle(future);
        }
    }

    public synchronized <V> void submitCallable(Callable<V> task) {
        if (task == null) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Callable or context for executor service can not be null");
        }
        this.executor.submit(this.newTaskFor(task));
    }

    @Deprecated
    public synchronized <V> void submit(Runnable task, V result, TableTaskContext context) {
        if (task == null) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Callable for executor service can not be null");
        }
        RunnableFuture<V> f = this.newTaskFor(task, result);
        Future<?> future = this.executor.submit(f);
        context.appendHandle(future);
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public List<Runnable> shutdownNow() {
        return this.executor.shutdownNow();
    }

    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    public int getActiveCount() {
        return this.executor.getActiveCount();
    }

    public int getCorePoolSize() {
        return this.executor.getCorePoolSize();
    }

    public int getMaximumPoolSize() {
        return this.executor.getMaximumPoolSize();
    }
}

