/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.schedule.impl;

import com.oceanbase.tools.datamocker.core.task.TableTaskContext;
import com.oceanbase.tools.datamocker.schedule.AbstractScheduler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultScheduler
extends AbstractScheduler {
    private static final Logger log = LoggerFactory.getLogger(DefaultScheduler.class);
    private final int maxConnectionSize;

    public DefaultScheduler(int maxConnectionSize) {
        this.maxConnectionSize = maxConnectionSize;
    }

    @Override
    protected Set<Set<String>> scheduleColumnTask(Set<String> groups, int active, int core, int max) {
        int allocate = (int)((double)(max - active) * 0.7) - 1;
        if (allocate <= 0) {
            log.error("The scheduling task failed because the idle thread resources are less than or equal to zero, freeThreadCount={}", (Object)allocate);
            return null;
        }
        int size = groups.size();
        HashSet<Set<String>> returnVal = new HashSet<Set<String>>();
        if (allocate > size) {
            for (String item : groups) {
                HashSet<String> itemSet = new HashSet<String>();
                itemSet.add(item);
                returnVal.add(itemSet);
            }
        } else {
            ArrayList<String> array = new ArrayList<String>(groups);
            int quotient = size / allocate;
            for (int i = 0; i < allocate; ++i) {
                int actualIndex;
                HashSet middleSet = new HashSet();
                for (int j = 0; j < quotient + 1 && (actualIndex = j * allocate + i) < size; ++j) {
                    middleSet.add(array.get(actualIndex));
                }
                returnVal.add(middleSet);
            }
        }
        return returnVal;
    }

    @Override
    protected Map<Set<String>, Integer> scheduleDataTask(Set<String> groups, int active, int core, int max) {
        int allocate = (int)((double)(max - active) * 0.7) - 1;
        if (allocate <= 0) {
            log.error("The scheduling task failed because the idle thread resources are less than or equal to zero, freeThreadCount={}", (Object)allocate);
            return null;
        }
        if (allocate > this.maxConnectionSize - 2) {
            allocate = this.maxConnectionSize - 2;
        }
        HashMap<Set<String>, Integer> returnVal = new HashMap<Set<String>, Integer>();
        returnVal.put(groups, allocate);
        return returnVal;
    }

    @Override
    protected void onSuccess(TableTaskContext context) {
    }

    @Override
    protected void onFailure(TableTaskContext context, Throwable e) {
    }

    @Override
    public ThreadPoolExecutor pool() {
        return null;
    }
}

