/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.schedule.impl;

import com.oceanbase.tools.datamocker.constraint.AbstractConstraint;
import com.oceanbase.tools.datamocker.core.read.ColumnReader;
import com.oceanbase.tools.datamocker.core.task.TableTaskContext;
import com.oceanbase.tools.datamocker.core.task.TableTaskMetaData;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import com.oceanbase.tools.datamocker.model.mock.MockColumnData;
import com.oceanbase.tools.datamocker.model.mock.MockRowData;
import com.oceanbase.tools.datamocker.schedule.AbstractMockTask;
import com.oceanbase.tools.datamocker.util.MockerBuffer;
import com.oceanbase.tools.datamocker.util.PrintUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateDataTask
extends AbstractMockTask {
    private static final Logger log = LoggerFactory.getLogger(GenerateDataTask.class);
    private final MockerBuffer buffer;
    private final List<ColumnReader<?>> readers;
    private final List<AbstractConstraint> constraints = new LinkedList<AbstractConstraint>();

    public GenerateDataTask(TableTaskMetaData metaData, TableTaskContext context, MockerBuffer buffer, List<ColumnReader<?>> readers, List<AbstractConstraint> constraints) {
        super(metaData, context);
        Validate.notNull((Object)buffer, (String)"Buffer for GenerateDataTask can not be null");
        Validate.notNull(readers, (String)"Column readers for GenerateDataTask can not be null");
        Validate.notNull(constraints, (String)"Constraints for GenerateDataTask can not be null");
        this.buffer = buffer;
        this.readers = readers;
        block0: for (AbstractConstraint constraint : constraints) {
            Set<String> colSet = constraint.columns().get(metaData.getTableName()).keySet();
            for (ColumnReader<?> reader : readers) {
                if (!colSet.contains(reader.getColumnName())) continue;
                this.constraints.add(constraint);
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(TableTaskMetaData metaData, TableTaskContext context) throws Exception {
        List columnNames = this.readers.stream().map(ColumnReader::getColumnName).collect(Collectors.toList());
        List constraintNames = this.constraints.stream().map(AbstractConstraint::name).collect(Collectors.toList());
        log.info("Start the data generation task, threadName={},constraintName={},columnName={}", new Object[]{Thread.currentThread().getName(), constraintNames, columnNames});
        long counter = 0L;
        long emptyLoopCount = 0L;
        Exception exception = null;
        long batchDataGenerateTime = 0L;
        long batchDataLineUpTime = 0L;
        long batchDataCheckTime = 0L;
        try {
            while (counter++ < metaData.getTotalCount() && !Thread.currentThread().isInterrupted() && this.interval() <= metaData.getTimeoutMilliseconds()) {
                MockRowData mockRowData = new MockRowData(this.readers.size());
                long startNanoTime = System.nanoTime();
                for (ColumnReader<?> columnReader : this.readers) {
                    MockColumnData<?> mockColumn = columnReader.read();
                    mockRowData.addMockColumn(mockColumn);
                }
                batchDataGenerateTime += System.nanoTime() - startNanoTime;
                boolean passCheck = true;
                ++emptyLoopCount;
                startNanoTime = System.nanoTime();
                for (AbstractConstraint constraint : this.constraints) {
                    if (constraint.check(mockRowData)) continue;
                    passCheck = false;
                    --counter;
                    break;
                }
                batchDataCheckTime += System.nanoTime() - startNanoTime;
                if (passCheck) {
                    emptyLoopCount = 0L;
                    long l = metaData.getTimeoutMilliseconds() - this.interval();
                    if (l <= 0L) {
                        l = 2000L;
                    }
                    startNanoTime = System.nanoTime();
                    this.buffer.write(mockRowData, l, TimeUnit.MILLISECONDS);
                    batchDataLineUpTime += System.nanoTime() - startNanoTime;
                    startNanoTime = System.nanoTime();
                    for (AbstractConstraint constraint : this.constraints) {
                        constraint.mark(mockRowData);
                    }
                    batchDataCheckTime += System.nanoTime() - startNanoTime;
                }
                if (emptyLoopCount > metaData.getTotalCount() * 100L || emptyLoopCount > 1000000L) {
                    throw new MockerException(MockerError.UNKNOWN_ERROR, String.format("Data generation cycle idling %d exceeds the maximum number of data generation %d, too much data cannot pass the constraint check, data generation is terminated", emptyLoopCount, metaData.getTotalCount() * 100L));
                }
                if (counter % metaData.getBatchSize() != 0L && counter != metaData.getTotalCount()) continue;
                log.debug("Batch data generation completed, generateTime={}, checkTime={}, lineUpTime={}", new Object[]{PrintUtil.convertToReadableTimeString(batchDataGenerateTime, TimeUnit.NANOSECONDS, TimeUnit.SECONDS, TimeUnit.MILLISECONDS), PrintUtil.convertToReadableTimeString(batchDataCheckTime, TimeUnit.NANOSECONDS, TimeUnit.SECONDS, TimeUnit.MILLISECONDS), PrintUtil.convertToReadableTimeString(batchDataLineUpTime, TimeUnit.NANOSECONDS, TimeUnit.SECONDS, TimeUnit.MILLISECONDS)});
                batchDataGenerateTime = 0L;
                batchDataLineUpTime = 0L;
                batchDataCheckTime = 0L;
            }
            --counter;
        }
        catch (Exception e) {
            exception = e;
            log.error("Data generation task execution failed", (Throwable)e);
        }
        finally {
            long writeTimeout = metaData.getTimeoutMilliseconds() - this.interval();
            if (writeTimeout < 0L) {
                writeTimeout = 0L;
            }
            this.buffer.close(writeTimeout, TimeUnit.MILLISECONDS);
        }
        if (exception != null) {
            throw exception;
        }
        if (Thread.currentThread().isInterrupted()) {
            log.warn("Data generation task execution is interrupted, totalDataGenerated={}, duration={} ms", (Object)counter, (Object)this.interval());
            throw new InterruptedException("data mock business has been interrupted by user");
        }
        if (this.interval() >= metaData.getTimeoutMilliseconds()) {
            log.warn("Data generation task execution timed out, totalDataGenerated={}, duration={} ms", (Object)counter, (Object)this.interval());
        }
        if (counter >= metaData.getTotalCount()) {
            log.info("Data generation task is executed successfully, totalDataGenerated={}, duration={} ms", (Object)counter, (Object)this.interval());
        }
        context.appendDataGenInfo(counter);
    }

    public void reloadConstraints(List<AbstractConstraint> constraints) {
        Validate.notNull(constraints, (String)"Constraints can not be null for GenerateDataTask#setConstraints");
        int length = this.constraints.size();
        for (int i = 0; i < length; ++i) {
            AbstractConstraint constraint = this.constraints.get(i);
            for (AbstractConstraint item : constraints) {
                if (!item.name().equals(constraint.name())) continue;
                this.constraints.set(i, item);
            }
        }
    }
}

