/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.schedule.impl;

import com.oceanbase.tools.datamocker.core.task.AbstractCallBack;
import com.oceanbase.tools.datamocker.core.task.TableTaskContext;
import com.oceanbase.tools.datamocker.core.task.TableTaskMetaData;
import com.oceanbase.tools.datamocker.model.enums.ObModeType;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import com.oceanbase.tools.datamocker.schedule.AbstractMockTask;
import com.oceanbase.tools.datamocker.util.DbObjectNameUtil;
import com.oceanbase.tools.datamocker.util.SqlUtil;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockDataAfterTask
extends AbstractMockTask {
    private static final Logger log = LoggerFactory.getLogger(MockDataAfterTask.class);
    private final DataSource dataSource;

    public MockDataAfterTask(TableTaskMetaData metaData, TableTaskContext context, DataSource dataSource) {
        super(metaData, context);
        if (dataSource == null) {
            MockerException e = new MockerException(MockerError.PARAMETER_ERROR, "Datasource can not be null");
            log.error("The initialization of the mock data destruction task failed because the data source could not be found", (Throwable)e);
            throw e;
        }
        this.dataSource = dataSource;
    }

    @Override
    public void execute(final TableTaskMetaData metaData, final TableTaskContext context) throws Throwable {
        String sql;
        log.info("Start the mock data destruction task");
        if (ObModeType.OB_ORACLE.equals((Object)metaData.getDialectType())) {
            sql = String.format("select count(*) from \"%s\".\"%s\"; ", DbObjectNameUtil.doubleCharToEscape(metaData.getSchema(), '\"'), DbObjectNameUtil.doubleCharToEscape(metaData.getTableName(), '\"'));
        } else if (ObModeType.OB_MYSQL.equals((Object)metaData.getDialectType())) {
            sql = String.format("select count(*) from `%s`.`%s`; ", DbObjectNameUtil.doubleCharToEscape(metaData.getSchema(), '`'), DbObjectNameUtil.doubleCharToEscape(metaData.getTableName(), '`'));
        } else {
            MockerException e = new MockerException(MockerError.INVALID_OB_MODE);
            log.error("Fail to execute mock data destruction task because the ObModeType is illegal, obModeType={}", (Object)metaData.getDialectType(), (Object)e);
            throw e;
        }
        SqlUtil.executeQuery(this.dataSource, sql, null, new AbstractCallBack<ResultSet>(){

            @Override
            public void doOnSuccess(ResultSet resultSet) throws Exception {
                ResultSetMetaData md = resultSet.getMetaData();
                if (md.getColumnCount() != 1) {
                    throw new MockerException(MockerError.ILLEGAL_RETURN_VALUE, String.format("Column count for \"select count(*) from \"%s\".\"%s\" is not equal to one, [%d!=1]", metaData.getSchema(), metaData.getTableName(), md.getColumnCount()));
                }
                if (resultSet.next()) {
                    long rowCount = resultSet.getLong(1);
                    context.setCurrentRecordNum(rowCount);
                }
            }

            @Override
            public void doOnFailure(ResultSet resultSet, Throwable e) throws Throwable {
                log.error("Fail to execute mock data destruction task", e);
                throw e;
            }
        });
    }
}

