/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.schedule.impl;

import com.oceanbase.tools.datamocker.core.task.TableTaskContext;
import com.oceanbase.tools.datamocker.core.task.TableTaskMetaData;
import com.oceanbase.tools.datamocker.core.write.AbstractMockWriter;
import com.oceanbase.tools.datamocker.model.enums.MockTaskStatus;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import com.oceanbase.tools.datamocker.schedule.AbstractMockTask;
import com.oceanbase.tools.datamocker.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputDataTask
extends AbstractMockTask {
    private static final Logger log = LoggerFactory.getLogger(OutputDataTask.class);
    private final List<AbstractMockWriter> writers;
    private final List<Boolean> writerSymbols;

    public OutputDataTask(TableTaskMetaData metaData, TableTaskContext context, List<AbstractMockWriter> writers) {
        super(metaData, context);
        if (writers == null || writers.size() == 0) {
            MockerException e = new MockerException(MockerError.PARAMETER_ERROR, "Data writer can not be null or empty");
            log.error("Initialization of data output task failed because the mocker writers is null or empty", (Throwable)e);
            throw e;
        }
        this.writers = writers;
        this.writerSymbols = new ArrayList<Boolean>(this.writers.size());
        for (int i = 0; i < writers.size(); ++i) {
            this.writerSymbols.add(Boolean.TRUE);
        }
    }

    @Override
    public void execute(TableTaskMetaData metaData, TableTaskContext context) throws Exception {
        List groupIds = this.writers.stream().map(AbstractMockWriter::groupId).collect(Collectors.toList());
        log.info("Start the data output task, groupIds={},threadName={}", groupIds, (Object)Thread.currentThread().getName());
        int length = this.writerSymbols.size();
        Throwable exception = null;
        while (!Thread.currentThread().isInterrupted() && this.interval() <= metaData.getTimeoutMilliseconds()) {
            try {
                Boolean shouldBreak = Boolean.FALSE;
                for (int i = 0; i < length; ++i) {
                    if (this.writerSymbols.get(i).booleanValue()) {
                        AbstractMockWriter writer = this.writers.get(i);
                        long writeCounter = writer.write();
                        if (writeCounter == Long.MIN_VALUE) {
                            this.writerSymbols.set(i, Boolean.FALSE);
                        } else {
                            context.appendWriteInfo(new Pair<String, Long>(writer.groupId(), writeCounter));
                        }
                    }
                    for (Boolean item : this.writerSymbols) {
                        shouldBreak = shouldBreak | item;
                    }
                }
                if (shouldBreak.booleanValue()) continue;
                break;
            }
            catch (Throwable e) {
                exception = e;
                log.error("Data output task execution failed", e);
                if (!(e instanceof InterruptedException) && !MockTaskStatus.CANCELED.equals((Object)context.getStatus())) continue;
                Thread.currentThread().interrupt();
            }
        }
        if (exception != null) {
            throw new MockerException(exception);
        }
        if (this.interval() >= metaData.getTimeoutMilliseconds()) {
            log.warn("Data output task execution timed out, duration={}ms", (Object)this.interval());
        }
        if (Thread.currentThread().isInterrupted()) {
            log.warn("Data output task execution is interrupted, duration={}ms", (Object)this.interval());
            throw new InterruptedException("data mock write thread has been interrupted by user");
        }
        if (this.interval() <= metaData.getTimeoutMilliseconds()) {
            log.info("Data output task is executed successfully, duration={}ms", (Object)this.interval());
        }
    }
}

