/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.util;

import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;

public class BitMap {
    private final int capacity;
    private final byte[] bytes;
    private static final int INCREASE_FACTOR = 4;
    private final int capacityWidth;

    public BitMap(int count) {
        if (count <= 0) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Capacity of the bitmap can not be equal to or smaller than zero");
        }
        int pow = new Double(String.valueOf(Math.log(count) / Math.log(2.0))).intValue() + 1;
        int factorPow = new Double(String.valueOf(Math.log(4.0) / Math.log(2.0))).intValue();
        this.capacity = 1 << pow + factorPow;
        this.capacityWidth = Integer.toBinaryString(Math.abs(this.capacity - 1)).length();
        this.bytes = new byte[this.capacity >> 3];
    }

    public int size() {
        return this.bytes.length;
    }

    public int capacity() {
        return this.capacity;
    }

    public synchronized boolean add(Object obj) {
        if (obj == null) {
            return false;
        }
        int hashCode = obj.hashCode();
        int n = this.getIndex(hashCode);
        this.bytes[n] = (byte)(this.bytes[n] | 1 << this.getPosition(hashCode));
        return true;
    }

    public boolean contains(Object obj) {
        if (obj == null) {
            return false;
        }
        int hashCode = obj.hashCode();
        return (this.bytes[this.getIndex(hashCode)] & 1 << this.getPosition(hashCode)) != 0;
    }

    public synchronized boolean clear(Object obj) {
        if (obj == null) {
            return false;
        }
        int hashCode = obj.hashCode();
        int n = this.getIndex(hashCode);
        this.bytes[n] = (byte)(this.bytes[n] & ~(1 << this.getPosition(hashCode)));
        return true;
    }

    public synchronized void clear() {
        int length = this.bytes.length;
        int i = 0;
        while (i < length) {
            int n = i++;
            this.bytes[n] = (byte)(this.bytes[n] & 0);
        }
    }

    private int getIndex(int key) {
        int hashKey = key ^ key >>> this.capacityWidth;
        return (hashKey & this.capacity() - 1) >> 3;
    }

    private int getPosition(int key) {
        return key & 7;
    }
}

