/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.util;

import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import com.oceanbase.tools.datamocker.util.BitMap;
import java.util.HashSet;
import java.util.Set;

public class DuplicatedJudger {
    private Set<Object> set;
    private BitMap bitMap;
    private final int maxCount;
    private int cursor;

    public DuplicatedJudger(int count) {
        if (count <= 0) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Count for DuplicatedJudger can not be equal to or smaleer than zero");
        }
        if (count < 10000) {
            this.set = new HashSet<Object>();
        } else {
            this.bitMap = new BitMap(count);
        }
        this.maxCount = count;
        this.cursor = 0;
    }

    public boolean contains(Object obj) {
        if (this.set != null) {
            return this.set.contains(obj);
        }
        return this.bitMap.contains(obj);
    }

    public boolean add(Object obj) {
        if (++this.cursor > this.maxCount) {
            throw new MockerException(MockerError.OPERATION_FAILURE, String.format("The max count for DuplicatedJudger is %d, can not add more", this.maxCount));
        }
        if (this.set != null) {
            return this.set.add(obj);
        }
        return this.bitMap.add(obj);
    }

    public void clear() {
        this.cursor = 0;
        if (this.set != null) {
            this.set.clear();
        } else {
            this.bitMap.clear();
        }
    }
}

