/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.util;

import com.oceanbase.tools.datamocker.core.task.AbstractDataPipe;
import com.oceanbase.tools.datamocker.model.mock.MockRowData;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class MockDataPipe
extends AbstractDataPipe<List<MockRowData>> {
    private final LinkedBlockingQueue<List<MockRowData>> queue = new LinkedBlockingQueue();

    public MockDataPipe(int maxRetained) {
        super(maxRetained);
    }

    @Override
    public void doWrite(List<MockRowData> row, long timout, TimeUnit timeUnit) throws InterruptedException {
        this.queue.put(row);
    }

    @Override
    public List<MockRowData> doRead(long timout, TimeUnit timeUnit) throws InterruptedException {
        return this.queue.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size() {
        LinkedBlockingQueue<List<MockRowData>> linkedBlockingQueue = this.queue;
        synchronized (linkedBlockingQueue) {
            return this.queue.size();
        }
    }
}

