/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.util;

import com.oceanbase.tools.datamocker.core.task.AbstractDataPipe;
import com.oceanbase.tools.datamocker.datatype.AbstractDataType;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import com.oceanbase.tools.datamocker.model.mock.MockColumnData;
import com.oceanbase.tools.datamocker.model.mock.MockRowData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockerBuffer {
    private static final Logger log = LoggerFactory.getLogger(MockerBuffer.class);
    private volatile boolean isClose = false;
    private CyclicBarrier synchronizer;
    private volatile boolean hasSet = false;
    private List<MockRowData> rows;
    private final Set<String> columnSet;
    private MockRowData currentRow;
    private final List<AbstractDataPipe<List<MockRowData>>> dataPipes;
    private final Long flushThreshold;
    private final Lock lock = new ReentrantLock();

    public MockerBuffer(Map<String, AbstractDataType<?, ? extends Comparable<?>>> tableSchema, Long batchSize, int concurrent) {
        Validate.isTrue((batchSize > 0L ? 1 : 0) != 0, (String)"Batch size can not be negative for MockerBuffer");
        Validate.notEmpty(tableSchema, (String)"Table schame can not be empty for MockerBuffer");
        this.columnSet = tableSchema.keySet();
        this.rows = new ArrayList<MockRowData>(batchSize.intValue() * 2);
        this.dataPipes = new ArrayList<AbstractDataPipe<List<MockRowData>>>();
        this.flushThreshold = batchSize;
        this.synchronizer = new CyclicBarrier(concurrent, null);
    }

    public MockerBuffer(Map<String, AbstractDataType<?, ? extends Comparable<?>>> tableSchema, Long batchSize) {
        Validate.isTrue((batchSize > 0L ? 1 : 0) != 0, (String)"Batch size can not be negative for MockerBuffer");
        Validate.notEmpty(tableSchema, (String)"Table schame can not be empty for MockerBuffer");
        this.columnSet = tableSchema.keySet();
        this.rows = new ArrayList<MockRowData>(batchSize.intValue() * 2);
        this.dataPipes = new ArrayList<AbstractDataPipe<List<MockRowData>>>();
        this.flushThreshold = batchSize;
        this.synchronizer = new CyclicBarrier(1, null);
    }

    public synchronized void setConcurrent(int count) {
        Validate.isTrue((count >= 0 ? 1 : 0) != 0, (String)"Concurrent can not be negative for MockBuffer#setConcurrent");
        if (this.hasSet) {
            throw new MockerException(MockerError.OPERATION_FAILURE, "Concurrent count can not be set repeatedly");
        }
        this.synchronizer = new CyclicBarrier(count, null);
    }

    public int getParties() {
        return this.synchronizer.getParties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(AbstractDataPipe<List<MockRowData>> dataPipe) {
        if (dataPipe == null) {
            return;
        }
        List<AbstractDataPipe<List<MockRowData>>> list = this.dataPipes;
        synchronized (list) {
            this.dataPipes.add(dataPipe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(MockRowData mockRowData, long timeout, TimeUnit timeUnit) throws Exception {
        Validate.notNull((Object)((Object)timeUnit), (String)"TimeUnit for buffer write can not be null");
        Validate.isTrue((timeout > 0L ? 1 : 0) != 0, (String)"Timeout for buffer write can not be negative");
        if (this.isClose) {
            throw new MockerException(MockerError.OPERATION_FAILURE, "Buffer has been closed");
        }
        this.hasSet = true;
        this.lock.lock();
        try {
            if (this.currentRow == null) {
                this.currentRow = new MockRowData();
            }
            List<MockColumnData<?>> mockColumns = mockRowData.getMockColumns();
            for (MockColumnData<?> mockColumn : mockColumns) {
                this.writeToCurrentRow(mockColumn);
            }
            this.reload(timeout, timeUnit);
        }
        finally {
            this.lock.unlock();
        }
        this.synchronizer.await(30L, TimeUnit.SECONDS);
    }

    public void write(MockColumnData<?> mockColumn, long timeout, TimeUnit timeUnit) throws Exception {
        this.write(new MockRowData(Collections.singletonList(mockColumn)), timeout, timeUnit);
    }

    private void writeToCurrentRow(MockColumnData<?> column) {
        Validate.notNull(column, (String)"MockColumn can not be null for MockBuffer#writeToCurrentRow");
        String columName = column.getColumnName();
        if (!this.columnSet.contains(columName)) {
            throw new MockerException(MockerError.UNKNOWN_COLUMN_NAME, String.format("Custom column \"%s\" is not in column set [%s]", columName, String.join((CharSequence)",", this.columnSet)));
        }
        if (this.currentRow.getMockColumn(columName) != null) {
            throw new MockerException(MockerError.PARAMETER_ERROR, String.format("Custom column \"%s\" is duplicate", columName));
        }
        this.currentRow.addMockColumn(column);
    }

    private void reload(long timeout, TimeUnit timeUnit) throws Exception {
        if (this.currentRow.columnNum() > this.columnSet.size()) {
            throw new MockerException(MockerError.UNKNOWN_COLUMN_NAME, String.format("There are unknown columns in current column [%s]", this.currentRow.columnNames()));
        }
        if (this.currentRow.columnNum() == this.columnSet.size()) {
            this.rows.add(this.currentRow);
            if ((long)this.rows.size() >= this.flushThreshold) {
                this.flush(timeout, timeUnit);
            }
            this.currentRow = new MockRowData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(long timeout, TimeUnit timeUnit) throws Exception {
        if (this.isClose) {
            return;
        }
        this.synchronizer.await();
        List<AbstractDataPipe<List<MockRowData>>> list = this.dataPipes;
        synchronized (list) {
            if (!this.isClose) {
                for (AbstractDataPipe<List<MockRowData>> dataPipe : this.dataPipes) {
                    if (dataPipe.isClosed()) continue;
                    dataPipe.write(this.rows, timeout, timeUnit);
                    dataPipe.close();
                }
                this.isClose = true;
            }
        }
    }

    public boolean isClosed() {
        return this.isClose;
    }

    public synchronized void flush(long timeout, TimeUnit timeUnit) throws Exception {
        if (this.dataPipes != null) {
            for (AbstractDataPipe<List<MockRowData>> dataPipe : this.dataPipes) {
                dataPipe.write(this.rows, timeout, timeUnit);
            }
        }
        this.rows = new ArrayList<MockRowData>(this.flushThreshold.intValue() * 2);
    }
}

