/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang.Validate;

public class PrintUtil {
    private static final List<TimeUnit> SORTED_TIMEUNIT_LIST = Arrays.asList(TimeUnit.DAYS, TimeUnit.HOURS, TimeUnit.MINUTES, TimeUnit.SECONDS, TimeUnit.MILLISECONDS, TimeUnit.MICROSECONDS, TimeUnit.NANOSECONDS);

    public static String convertToReadableTimeString(long timestamp, TimeUnit timeUnit, TimeUnit maxTimeUnit, TimeUnit minTimeUnit) {
        TimeUnit currentUnit;
        long valueTime;
        Validate.isTrue((timestamp >= 0L ? 1 : 0) != 0, (String)"Time can not be negative for PrintUtil#convertToReadableTimeString");
        Validate.notNull((Object)((Object)timeUnit), (String)"TimeUnit can not be null for PrintUtil#convertToReadableTimeString");
        Validate.notNull((Object)((Object)maxTimeUnit), (String)"MaxTimeUnit can not be null for PrintUtil#convertToReadableTimeString");
        Validate.notNull((Object)((Object)minTimeUnit), (String)"MinTimeUnit can not be null for PrintUtil#convertToReadableTimeString");
        Validate.isTrue((maxTimeUnit.compareTo(minTimeUnit) >= 0 ? 1 : 0) != 0, (String)"MinTimeUnit can not be bigger than MaxTimeUnit");
        int beginIndex = -1;
        int endIndex = -1;
        for (int i = 0; i < SORTED_TIMEUNIT_LIST.size(); ++i) {
            TimeUnit unitItem = SORTED_TIMEUNIT_LIST.get(i);
            if (unitItem.compareTo(maxTimeUnit) > 0 || unitItem.convert(timestamp, timeUnit) == 0L) continue;
            beginIndex = i;
            if (unitItem.compareTo(minTimeUnit) >= 0) {
                endIndex = SORTED_TIMEUNIT_LIST.indexOf((Object)minTimeUnit);
                break;
            }
            endIndex = beginIndex;
            break;
        }
        if (beginIndex == -1) {
            return "0 " + PrintUtil.toReadableTimeUnit(minTimeUnit);
        }
        HashMap<TimeUnit, Long> returnMap = new HashMap<TimeUnit, Long>();
        long remainingTime = timestamp;
        for (int i = beginIndex; i <= endIndex && (valueTime = (currentUnit = SORTED_TIMEUNIT_LIST.get(i)).convert(remainingTime, timeUnit)) != 0L; ++i) {
            returnMap.putIfAbsent(currentUnit, valueTime);
            remainingTime -= timeUnit.convert(valueTime, currentUnit);
        }
        return returnMap.entrySet().stream().sorted((o1, o2) -> ((TimeUnit)((Object)((Object)o2.getKey()))).compareTo((Enum)o1.getKey())).map(timeUnitLongEntry -> timeUnitLongEntry.getValue() + " " + PrintUtil.toReadableTimeUnit((TimeUnit)((Object)((Object)timeUnitLongEntry.getKey())))).collect(Collectors.joining(" "));
    }

    private static String toReadableTimeUnit(TimeUnit timeUnit) {
        if (TimeUnit.DAYS.equals((Object)timeUnit)) {
            return "days";
        }
        if (TimeUnit.HOURS.equals((Object)timeUnit)) {
            return "hrs";
        }
        if (TimeUnit.MINUTES.equals((Object)timeUnit)) {
            return "mins";
        }
        if (TimeUnit.SECONDS.equals((Object)timeUnit)) {
            return "secs";
        }
        if (TimeUnit.MILLISECONDS.equals((Object)timeUnit)) {
            return "millSecs";
        }
        if (TimeUnit.MICROSECONDS.equals((Object)timeUnit)) {
            return "microSecs";
        }
        return "nanoSecs";
    }
}

