/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.util;

import com.oceanbase.tools.datamocker.model.exception.MockerException;

public class Range<T extends Comparable<? super T>> {
    private final T min;
    private final T max;

    public Range(T min, T max) {
        if (min.compareTo(max) > 0) {
            throw new MockerException("Min value can not be bigger than max value");
        }
        this.min = min;
        this.max = max;
    }

    public boolean contain(T value) {
        return this.min.compareTo(value) <= 0 && this.max.compareTo(value) >= 0;
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range that = (Range)o;
        return this.min.compareTo(that.min) == 0 && this.max.compareTo(that.max) == 0;
    }

    public int hashCode() {
        String buffer = this.min.hashCode() + this.max.hashCode() + "";
        return buffer.hashCode();
    }
}

