/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.util;

import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import dk.brics.automaton.Automaton;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.State;
import dk.brics.automaton.Transition;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class RegExpTextBuilder {
    private static final Pattern PATTERN_REQUOTED = Pattern.compile("\\\\Q(.*?)\\\\E");
    private static final Pattern PATTERN_SPECIAL = Pattern.compile("[.^$*+?(){|\\[\\\\@]");
    private final Automaton automaton;
    private final Random random;

    public RegExpTextBuilder(String regex, Random random) {
        if (StringUtils.isBlank((String)regex) || random == null) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "RegExp or random obj can not be null");
        }
        this.automaton = new RegExp(RegExpTextBuilder.requote(regex)).toAutomaton();
        this.random = random;
    }

    public RegExpTextBuilder(String regex) {
        this(regex, new Random());
    }

    public String generate() {
        StringBuilder builder = new StringBuilder();
        this.generate(builder, this.automaton.getInitialState());
        return builder.toString();
    }

    public String generate(int minLength, int maxLength) {
        List transitions;
        int walkLength;
        StringBuilder builder = new StringBuilder();
        State state = this.automaton.getInitialState();
        int targetLength = this.getRandomInt(minLength, maxLength, this.random);
        for (walkLength = 0; walkLength < targetLength; ++walkLength) {
            transitions = state.getSortedTransitions(false);
            if (transitions.size() == 0) {
                if (walkLength >= minLength) {
                    assert (state.isAccept());
                    return builder.toString();
                }
                throw new MockerException(String.format("Reached accept state before min length (current = %d < min = %d)", walkLength, minLength));
            }
            List nonFinalTransitions = transitions.stream().filter(t -> !t.getDest().getTransitions().isEmpty()).collect(Collectors.toList());
            if (!nonFinalTransitions.isEmpty()) {
                transitions = nonFinalTransitions;
            }
            int option = this.getRandomInt(0, transitions.size() - 1, this.random);
            Transition transition = (Transition)transitions.get(option);
            this.appendChoice(builder, transition);
            state = transition.getDest();
        }
        while (!state.isAccept() && walkLength < maxLength) {
            transitions = state.getSortedTransitions(false);
            if (transitions.size() == 0) {
                assert (state.isAccept());
                return builder.toString();
            }
            int option = this.getRandomInt(0, transitions.size() - 1, this.random);
            Transition transition = (Transition)transitions.get(option);
            this.appendChoice(builder, transition);
            state = transition.getDest();
            ++walkLength;
        }
        if (state.isAccept()) {
            return builder.toString();
        }
        throw new MockerException(String.format("Exceeded max walk length (%d) before reaching an accept state: target length was %d (min length = %d)", maxLength, targetLength, minLength));
    }

    private void generate(StringBuilder builder, State state) {
        List transitions = state.getSortedTransitions(false);
        if (transitions.size() == 0) {
            assert (state.isAccept());
            return;
        }
        int nroptions = state.isAccept() ? transitions.size() : transitions.size() - 1;
        int option = this.getRandomInt(0, nroptions, this.random);
        if (state.isAccept() && option == 0) {
            return;
        }
        Transition transition = (Transition)transitions.get(option - (state.isAccept() ? 1 : 0));
        this.appendChoice(builder, transition);
        this.generate(builder, transition.getDest());
    }

    private void appendChoice(StringBuilder builder, Transition transition) {
        char c = (char)this.getRandomInt(transition.getMin(), transition.getMax(), this.random);
        builder.append(c);
    }

    private int getRandomInt(int min, int max, Random random) {
        int maxForRandom = max - min + 1;
        return random.nextInt(maxForRandom) + min;
    }

    private static String requote(String regex) {
        StringBuilder sb = new StringBuilder(regex);
        Matcher matcher = PATTERN_REQUOTED.matcher(sb);
        while (matcher.find()) {
            sb.replace(matcher.start(), matcher.end(), PATTERN_SPECIAL.matcher(matcher.group(1)).replaceAll("\\\\$0"));
        }
        return sb.toString();
    }
}

