/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.util;

import com.oceanbase.jdbc.extend.datatype.INTERVALDS;
import com.oceanbase.jdbc.extend.datatype.INTERVALYM;
import com.oceanbase.tools.datamocker.core.task.AbstractCallBack;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlUtil {
    private static final Logger log = LoggerFactory.getLogger(SqlUtil.class);

    public static void executeQuery(Connection connection, String sql, Object[] params, AbstractCallBack<ResultSet> callBack) throws Throwable {
        block36: {
            if (connection == null || sql == null) {
                MockerException e = new MockerException(MockerError.PARAMETER_ERROR, "Connection or SQL can not be null");
                if (callBack != null) {
                    callBack.onFailure(null, e);
                }
                return;
            }
            try {
                connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                if (callBack != null) {
                    callBack.onFailure(null, e);
                }
                return;
            }
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                if (params != null) {
                    int length = params.length;
                    for (int i = 0; i < length; ++i) {
                        if (params[i] instanceof INTERVALYM || params[i] instanceof INTERVALDS) {
                            throw new MockerException(MockerError.NOT_SUPPORT_FEATURE, "OceanBase have to support PS protocol for INTERVALYM or INTERVALDS");
                        }
                        statement.setObject(i + 1, params[i]);
                    }
                }
                try (ResultSet resultSet = statement.executeQuery();){
                    if (callBack == null) break block36;
                    try {
                        callBack.onSuccess(resultSet);
                    }
                    catch (Throwable e) {
                        log.error("Some errors happened when executeQuery call back method executed", e);
                        throw e;
                    }
                }
            }
            catch (Throwable e) {
                if (callBack == null) break block36;
                callBack.onFailure(null, e);
            }
        }
    }

    public static void executeQuery(DataSource dataSource, String sql, Object[] params, AbstractCallBack<ResultSet> callBack) throws Throwable {
        block16: {
            if (dataSource == null) {
                MockerException e = new MockerException(MockerError.PARAMETER_ERROR, "Datasource can not be null");
                if (callBack != null) {
                    callBack.onFailure(null, e);
                }
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                SqlUtil.executeQuery(connection, sql, params, callBack);
            }
            catch (Throwable e) {
                if (callBack == null) break block16;
                callBack.onFailure(null, e);
            }
        }
    }

    public static void executeUpdate(Connection connection, String sql, Object[] params, AbstractCallBack<Integer> callBack) throws Throwable {
        block24: {
            if (connection == null || sql == null) {
                MockerException e = new MockerException(MockerError.PARAMETER_ERROR, "Connection or SQL can not be null");
                if (callBack != null) {
                    callBack.onFailure(null, e);
                }
                return;
            }
            try {
                connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                if (callBack != null) {
                    callBack.onFailure(null, e);
                }
                return;
            }
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                if (params != null) {
                    int length = params.length;
                    for (int i = 0; i < length; ++i) {
                        if (params[i] instanceof INTERVALYM || params[i] instanceof INTERVALDS) {
                            throw new MockerException(MockerError.NOT_SUPPORT_FEATURE, "OceanBase have to support ps protocol for INTERVALYM or INTERVALDS");
                        }
                        statement.setObject(i + 1, params[i]);
                    }
                }
                if (callBack == null) break block24;
                try {
                    callBack.onSuccess(statement.executeUpdate());
                }
                catch (Throwable e) {
                    log.error("Some errors happened when executeUpdate onSuccess call back method executed", e);
                    throw e;
                }
            }
            catch (Throwable e) {
                if (callBack == null) break block24;
                callBack.onFailure(null, e);
            }
        }
    }

    public static void executeUpdate(DataSource dataSource, String sql, Object[] params, AbstractCallBack<Integer> callBack) throws Throwable {
        block16: {
            if (dataSource == null) {
                MockerException e = new MockerException(MockerError.PARAMETER_ERROR, "Datasource can not be null");
                if (callBack != null) {
                    callBack.onFailure(null, e);
                }
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                SqlUtil.executeUpdate(connection, sql, params, callBack);
            }
            catch (Throwable e) {
                if (callBack == null) break block16;
                callBack.onFailure(null, e);
            }
        }
    }

    public static void executeBatch(Connection connection, String sql, Object[][] params, AbstractCallBack<int[]> callBack) throws Throwable {
        block26: {
            if (connection == null || sql == null) {
                MockerException e = new MockerException(MockerError.PARAMETER_ERROR, "Connection or sql can not be null");
                if (callBack != null) {
                    callBack.onFailure(null, e);
                }
                return;
            }
            try {
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                if (callBack != null) {
                    callBack.onFailure(null, e);
                }
                return;
            }
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                if (params == null) {
                    throw new MockerException(MockerError.FAIL_TO_EXECUTE_SQL, "Param can not be null for batch update");
                }
                for (Object[] innerParams : params) {
                    if (innerParams == null) {
                        throw new MockerException(MockerError.FAIL_TO_EXECUTE_SQL, "Param can not be null for batch update");
                    }
                    int innerLength = innerParams.length;
                    for (int j = 0; j < innerLength; ++j) {
                        if (innerParams[j] instanceof INTERVALYM || innerParams[j] instanceof INTERVALDS) {
                            throw new MockerException(MockerError.NOT_SUPPORT_FEATURE, "OceanBase have to support PS protocol for INTERVALYM or INTERVALDS");
                        }
                        statement.setObject(j + 1, innerParams[j]);
                    }
                    statement.addBatch();
                }
                int[] result = statement.executeBatch();
                connection.commit();
                statement.clearBatch();
                statement.clearParameters();
                if (callBack == null) break block26;
                try {
                    callBack.onSuccess(result);
                }
                catch (Throwable e) {
                    log.error("Some errors happened when executeBatch onSuccess call back method executed", e);
                    throw e;
                }
            }
            catch (Throwable e) {
                connection.rollback();
                if (callBack == null) break block26;
                callBack.onFailure(null, e);
            }
        }
    }

    public static void executeBatch(DataSource dataSource, String sql, Object[][] params, AbstractCallBack<int[]> callBack) throws Throwable {
        block16: {
            if (dataSource == null) {
                MockerException e = new MockerException(MockerError.PARAMETER_ERROR, "Datasource can not be null");
                if (callBack != null) {
                    callBack.onFailure(null, e);
                }
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                SqlUtil.executeBatch(connection, sql, params, callBack);
            }
            catch (Throwable e) {
                if (callBack == null) break block16;
                callBack.onFailure(null, e);
            }
        }
    }
}

