/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker;

import com.oceanbase.tools.datamocker.core.Dispatcher;
import com.oceanbase.tools.datamocker.core.task.TableTaskInfo;
import com.oceanbase.tools.datamocker.schedule.AbstractScheduler;
import com.oceanbase.tools.datamocker.schedule.MockContext;
import lombok.NonNull;

public class ObDataMocker {
    private final AbstractScheduler scheduler;
    private final Dispatcher<TableTaskInfo> dispatcher;

    public ObDataMocker(@NonNull Dispatcher<TableTaskInfo> dispatcher, @NonNull AbstractScheduler scheduler) {
        if (dispatcher == null) {
            throw new NullPointerException("dispatcher is marked @NonNull but is null");
        }
        if (scheduler == null) {
            throw new NullPointerException("scheduler is marked @NonNull but is null");
        }
        this.scheduler = scheduler;
        this.dispatcher = dispatcher;
    }

    public MockContext start() {
        return this.scheduler.execute(this.dispatcher);
    }

    public int size() {
        if (this.dispatcher == null) {
            return -1;
        }
        return this.dispatcher.getWidth();
    }

    public int size(int index) {
        if (index < 0 || this.dispatcher == null) {
            return -1;
        }
        return this.dispatcher.getTaskSize(index);
    }
}

