/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker;

import com.oceanbase.tools.datamocker.ObDataMocker;
import com.oceanbase.tools.datamocker.constraint.Constraint;
import com.oceanbase.tools.datamocker.constraint.ConstraintBuilder;
import com.oceanbase.tools.datamocker.core.DataSourceFactory;
import com.oceanbase.tools.datamocker.core.Dispatcher;
import com.oceanbase.tools.datamocker.core.read.ColumnReader;
import com.oceanbase.tools.datamocker.core.task.TableTaskInfo;
import com.oceanbase.tools.datamocker.core.task.TableTaskMetaData;
import com.oceanbase.tools.datamocker.core.write.DataWriter;
import com.oceanbase.tools.datamocker.core.write.JdbcWriter;
import com.oceanbase.tools.datamocker.core.write.SqlScriptOutput;
import com.oceanbase.tools.datamocker.core.write.SqlScriptWriter;
import com.oceanbase.tools.datamocker.datatype.AbstractDataType;
import com.oceanbase.tools.datamocker.model.config.MockColumnConfig;
import com.oceanbase.tools.datamocker.model.config.MockTableConfig;
import com.oceanbase.tools.datamocker.model.config.MockTaskConfig;
import com.oceanbase.tools.datamocker.model.enums.ObModeType;
import com.oceanbase.tools.datamocker.schedule.AbstractScheduler;
import com.oceanbase.tools.datamocker.schedule.DefaultScheduler;
import com.oceanbase.tools.dbbrowser.util.MySQLSqlBuilder;
import com.oceanbase.tools.dbbrowser.util.OracleSqlBuilder;
import com.oceanbase.tools.dbbrowser.util.SqlBuilder;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import javax.sql.DataSource;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ObMockerFactory {
    private static final Logger log = LoggerFactory.getLogger(ObMockerFactory.class);
    private final MockTaskConfig taskConfig;

    public ObMockerFactory(@NonNull MockTaskConfig taskConfig) {
        if (taskConfig == null) {
            throw new NullPointerException("taskConfig is marked @NonNull but is null");
        }
        this.taskConfig = taskConfig;
    }

    public ObDataMocker create() {
        return this.create(new DefaultScheduler());
    }

    public ObDataMocker create(@NonNull AbstractScheduler scheduler) {
        if (scheduler == null) {
            throw new NullPointerException("scheduler is marked @NonNull but is null");
        }
        DataSource dataSource = null;
        try {
            String logDir = this.taskConfig.getLogDir();
            MDC.put((String)"mocktask.workspace", (String)logDir);
            DataSourceFactory factory = new DataSourceFactory(this.taskConfig.getDbConfig());
            factory.setDriverClassName(this.taskConfig.getDriverClassName());
            factory.setProtocolName(this.taskConfig.getProtocolName());
            dataSource = factory.generate();
            Dispatcher<TableTaskInfo> dispatcher = this.generate(this.taskConfig, dataSource, logDir);
            ObDataMocker obDataMocker = new ObDataMocker(dispatcher, scheduler);
            return obDataMocker;
        }
        catch (IOException | SQLException throwables) {
            throw new IllegalArgumentException(throwables);
        }
        finally {
            if (dataSource instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)((Object)dataSource)).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private Dispatcher<TableTaskInfo> generate(MockTaskConfig taskConfig, DataSource ds, String logDir) throws SQLException, IOException {
        List<MockTableConfig> tableConfigs = taskConfig.getTables();
        Validate.notEmpty(tableConfigs, (String)"TaskConfig can not be empty");
        ObModeType obModeType = taskConfig.getDialectType();
        Dispatcher<TableTaskInfo> dispatcher = new Dispatcher<TableTaskInfo>(tableConfigs.size(), logDir);
        for (int i = 0; i < tableConfigs.size(); ++i) {
            MockTableConfig tableConfig = tableConfigs.get(i);
            List<Constraint> constraints = this.getConstraints(tableConfig, ds, obModeType);
            SqlScriptOutput output = this.getOutput(tableConfig);
            dispatcher.setObj(i, new TableTaskInfo(this.getDataWriters(output, tableConfig), this.getColumnReader(tableConfig, constraints), this.getDataSourceFactory(tableConfig), constraints, new TableTaskMetaData(this.getTableSchema(tableConfig), tableConfig, logDir), output, this.getSqlBuilder(obModeType)));
        }
        return dispatcher;
    }

    private Map<String, AbstractDataType<?, ? extends Comparable<?>>> getTableSchema(MockTableConfig tableConfig) {
        HashMap columnName2DataType = new HashMap();
        for (MockColumnConfig columnConfig : tableConfig.getColumns()) {
            columnName2DataType.putIfAbsent(columnConfig.getColumnName(), columnConfig.getDataType());
        }
        return columnName2DataType;
    }

    private List<Constraint> getConstraints(MockTableConfig tableConfig, DataSource dataSource, ObModeType dialectType) {
        return ConstraintBuilder.builder().dataSource(dataSource).obModeType(dialectType).tableName(tableConfig.getTableName()).schema(tableConfig.getSchemaName()).totalMockCount(tableConfig.getTotalCount().intValue()).columnName2DataType(this.getTableSchema(tableConfig)).build().getConstraints();
    }

    private DataSourceFactory getDataSourceFactory(MockTableConfig tableConfig) {
        HashMap<String, String> realParam = new HashMap<String, String>();
        realParam.put("autoReconnect", "true");
        realParam.put("rewriteBatchedStatements", "true");
        realParam.put("emulateUnsupportedPstmts", "false");
        Map<String, String> param = this.taskConfig.getDbConfig().getConnectParam();
        if (param != null) {
            Set<Map.Entry<String, String>> entries = param.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                realParam.put(entry.getKey(), entry.getValue());
            }
        }
        DataSourceFactory factory = new DataSourceFactory(this.taskConfig.getDbConfig());
        factory.setDriverClassName(this.taskConfig.getDriverClassName());
        factory.setProtocolName(this.taskConfig.getProtocolName());
        factory.setConnectionInitSql(this.taskConfig.getConnectionInitSql());
        factory.setParams(realParam);
        factory.setTimeoutMillis(tableConfig.getTimeoutMillis());
        factory.setMaxPoolSize(this.taskConfig.getMaxConnectionSize());
        return factory;
    }

    private SqlScriptOutput getOutput(MockTableConfig tableConfig) throws IOException {
        File file = new File(tableConfig.getOutputDir());
        if (file.exists()) {
            if (!file.delete()) {
                throw new IOException("Failed to delete a dir " + file.getAbsolutePath());
            }
            FileUtils.forceMkdir((File)file);
        } else {
            FileUtils.forceMkdir((File)file);
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Location is not a dir, " + file.getAbsolutePath());
        }
        return new SqlScriptOutput(file, tableConfig.getTableName(), tableConfig.getMaxSingleFileSizeInBytes());
    }

    private List<DataWriter> getDataWriters(SqlScriptOutput output, MockTableConfig tableConfig) throws SQLException {
        LinkedList<DataWriter> dataWriters = new LinkedList<DataWriter>();
        dataWriters.add(new SqlScriptWriter(output, tableConfig.getMaxFileOutputSizeInBytes(), this.getSqlBuilder(this.taskConfig.getDialectType()), tableConfig.getSchemaName(), tableConfig.getTableName()));
        dataWriters.add(new JdbcWriter(this.getDataSourceFactory(tableConfig), this.getSqlBuilder(this.taskConfig.getDialectType()), tableConfig.getConcurrent(), tableConfig.getSchemaName(), tableConfig.getTableName()));
        return dataWriters;
    }

    private List<ColumnReader<?>> getColumnReader(MockTableConfig tableConfig, List<Constraint> constraints) {
        List<MockColumnConfig> columnConfigs = tableConfig.getColumns();
        ArrayList<HashSet<String>> colGroupList = new ArrayList<HashSet<String>>();
        for (Constraint constraint : constraints) {
            Map<String, Integer> cols = constraint.columns().get(tableConfig.getTableName());
            Set<String> set = cols.keySet();
            colGroupList.add(new HashSet<String>(set));
        }
        int length = colGroupList.size();
        for (int i = 0; i < length; ++i) {
            for (int j = i + 1; j < length; ++j) {
                HashSet hashSet = new HashSet((Collection)colGroupList.get(i));
                hashSet.retainAll((Collection)colGroupList.get(j));
                if (hashSet.size() == 0) continue;
                ((Set)colGroupList.get(i)).addAll((Collection)colGroupList.get(j));
                colGroupList.remove(j);
                --length;
                --j;
            }
        }
        HashMap<String, Set> groupMap = new HashMap<String, Set>();
        for (Set set : colGroupList) {
            groupMap.put(UUID.randomUUID().toString(), set);
        }
        LinkedList returnValue = new LinkedList();
        for (MockColumnConfig columnConfig : columnConfigs) {
            AbstractDataType<?, ? extends Comparable<?>> dataType = columnConfig.getDataType();
            String columnName = columnConfig.getColumnName();
            Set entrySet = groupMap.entrySet();
            ColumnReader reader = null;
            for (Map.Entry item : entrySet) {
                String groupId = (String)item.getKey();
                if (!((Set)item.getValue()).contains(columnName)) continue;
                reader = new ColumnReader(dataType, columnName, groupId);
                break;
            }
            if (reader == null) {
                reader = new ColumnReader(dataType, columnName, UUID.randomUUID().toString());
            }
            returnValue.add(reader);
        }
        return returnValue;
    }

    private Supplier<SqlBuilder> getSqlBuilder(ObModeType obModeType) {
        switch (obModeType) {
            case OB_ORACLE: {
                return OracleSqlBuilder::new;
            }
            case OB_MYSQL: {
                return MySQLSqlBuilder::new;
            }
        }
        throw new UnsupportedOperationException("Unknown dialect type, " + (Object)((Object)obModeType));
    }
}

