/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.constraint;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.oceanbase.tools.datamocker.constraint.Constraint;
import com.oceanbase.tools.datamocker.constraint.ConstraintFactory;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import lombok.NonNull;

abstract class AbstractConstraintFactory
implements ConstraintFactory {
    protected static final String LIST_PK_KEY = "list-pk-constraints";
    protected static final String LIST_UK_KEY = "list-unique-constraints";
    protected static final String LIST_CHECK_CONSTRAINT_KEY = "list-check-constraints";
    protected static final String LIST_FOREIGN_CONSTRAINT_KEY = "list-foreign-constraints";
    protected static final String OB_ORACLE_CONSTRAINT_FILE = "sql/constraint/oboracle.yaml";
    protected static final String OB_MYSQL_CONSTRAINT_FILE = "sql/constraint/obmysql.yaml";
    private static final Map<String, Map<String, String>> FILENAME2KEY2SQL = new HashMap<String, Map<String, String>>();
    private final DataSource dataSource;
    private final String schema;
    private final String tableName;

    public AbstractConstraintFactory(@NonNull DataSource dataSource, @NonNull String schema, @NonNull String tableName) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked @NonNull but is null");
        }
        if (schema == null) {
            throw new NullPointerException("schema is marked @NonNull but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked @NonNull but is null");
        }
        this.schema = schema;
        this.dataSource = dataSource;
        this.tableName = tableName;
    }

    @Override
    public List<Constraint> generate() {
        return this.doGenerate(AbstractConstraintFactory.getSqlContent(this.getFileName(), this.getListConstraintsKey()), this.dataSource, this.schema, this.tableName);
    }

    protected static String getSqlContent(String fileName, String key) {
        Map<String, String> key2Sqls = FILENAME2KEY2SQL.get(fileName);
        if (key2Sqls == null) {
            throw new IllegalStateException("Failed to get file content, " + fileName);
        }
        String sql = key2Sqls.get(key);
        if (sql != null) {
            return sql;
        }
        throw new IllegalStateException("Failed to sql content, " + key);
    }

    protected abstract List<Constraint> doGenerate(String var1, DataSource var2, String var3, String var4);

    protected abstract String getFileName();

    protected abstract String getListConstraintsKey();

    private static void addSchemaFile(String filePath) {
        URL url = AbstractConstraintFactory.class.getClassLoader().getResource(filePath);
        if (url == null) {
            throw new IllegalStateException("Failed to load file, " + filePath);
        }
        Map<String, String> key2Sqls = AbstractConstraintFactory.fromYaml(url);
        if (key2Sqls == null) {
            return;
        }
        FILENAME2KEY2SQL.put(filePath, key2Sqls);
    }

    private static Map<String, String> fromYaml(URL url) {
        if (url == null) {
            return null;
        }
        try {
            return (Map)AbstractConstraintFactory.yamlMapper().readValue(url, (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (IOException ex) {
            return null;
        }
    }

    private static ObjectMapper yamlMapper() {
        ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        yamlMapper.setPropertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategy.SnakeCaseStrategy());
        yamlMapper.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
        yamlMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return yamlMapper;
    }

    static {
        AbstractConstraintFactory.addSchemaFile(OB_ORACLE_CONSTRAINT_FILE);
        AbstractConstraintFactory.addSchemaFile(OB_MYSQL_CONSTRAINT_FILE);
    }
}

