/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.constraint;

import com.oceanbase.tools.datamocker.constraint.AbstractConstraintFactory;
import com.oceanbase.tools.datamocker.constraint.Constraint;
import com.oceanbase.tools.datamocker.constraint.UniqueConstraint;
import com.oceanbase.tools.datamocker.model.dbobject.ConstraintColumn;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import com.oceanbase.tools.datamocker.util.SerializeUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.NonNull;
import org.springframework.jdbc.core.JdbcTemplate;

abstract class AbstractUniqueConstraintFactory
extends AbstractConstraintFactory {
    private final int totalCount;

    public AbstractUniqueConstraintFactory(@NonNull DataSource dataSource, @NonNull String schema, @NonNull String tableName, int totalCount) {
        super(dataSource, schema, tableName);
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked @NonNull but is null");
        }
        if (schema == null) {
            throw new NullPointerException("schema is marked @NonNull but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked @NonNull but is null");
        }
        this.totalCount = totalCount;
    }

    @Override
    protected List<Constraint> doGenerate(String querySql, DataSource dataSource, String schema, String tableName) {
        List cols = (List)new JdbcTemplate(dataSource).query(querySql, ps -> {
            ps.setString(1, schema);
            ps.setString(2, tableName);
        }, rs -> {
            try {
                return SerializeUtil.getList(rs, ConstraintColumn.class);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException(e);
            }
        });
        if (cols == null) {
            throw new IllegalStateException("Failed to get constraint columns");
        }
        return cols.stream().collect(Collectors.groupingBy(ConstraintColumn::getConstraintName)).entrySet().stream().map(entry -> {
            HashMap<String, Map<String, Integer>> columnMap = new HashMap<String, Map<String, Integer>>();
            for (ConstraintColumn item : (List)entry.getValue()) {
                Number position;
                this.checkVirtualColumn(dataSource, item);
                Map map = columnMap.getOrDefault(item.getTableName(), new HashMap());
                if (item.getPosition() instanceof BigDecimal) {
                    position = (BigDecimal)item.getPosition();
                    map.putIfAbsent(item.getColumnName(), ((BigDecimal)position).intValue());
                } else if (item.getPosition() instanceof Long) {
                    position = (Long)item.getPosition();
                    map.putIfAbsent(item.getColumnName(), ((Long)position).intValue());
                } else {
                    throw new MockerException(MockerError.ILLEGAL_RETURN_VALUE, "Position's type is not support");
                }
                columnMap.put(item.getTableName(), map);
            }
            return new UniqueConstraint((String)entry.getKey(), tableName, columnMap, this.totalCount);
        }).collect(Collectors.toList());
    }

    protected abstract void checkVirtualColumn(DataSource var1, ConstraintColumn var2);
}

