/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.constraint;

import com.oceanbase.tools.datamocker.constraint.AbstractUniqueConstraintFactory;
import com.oceanbase.tools.datamocker.constraint.Constraint;
import com.oceanbase.tools.datamocker.constraint.ConstraintFactory;
import com.oceanbase.tools.datamocker.constraint.OBMysqlPKConstraintFactory;
import com.oceanbase.tools.datamocker.constraint.OBMysqlUKConstraintFactory;
import com.oceanbase.tools.datamocker.constraint.OBOracleCheckConstraintFactory;
import com.oceanbase.tools.datamocker.constraint.OBOracleForeignConstraintFactory;
import com.oceanbase.tools.datamocker.constraint.OBOraclePKConstraintFactory;
import com.oceanbase.tools.datamocker.constraint.OBOracleUKConstraintFactory;
import com.oceanbase.tools.datamocker.datatype.AbstractDataType;
import com.oceanbase.tools.datamocker.model.enums.ObModeType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintBuilder {
    private static final Logger log = LoggerFactory.getLogger(ConstraintBuilder.class);
    private final ObModeType obModeType;
    private final DataSource dataSource;
    private final String schema;
    private final String tableName;
    private final int totalMockCount;
    private final Map<String, AbstractDataType<?, ? extends Comparable<?>>> columnName2DataType;

    public List<Constraint> getConstraints() {
        return this.getAllConstraintFactories().stream().flatMap(f -> {
            List<Constraint> constraints = f.generate();
            if (f instanceof AbstractUniqueConstraintFactory && this.columnName2DataType != null) {
                ConstraintBuilder.validateConstraints(constraints, this.tableName, this.columnName2DataType, this.totalMockCount);
            }
            return constraints.stream();
        }).collect(Collectors.toList());
    }

    public List<ConstraintFactory> getAllConstraintFactories() {
        switch (this.obModeType) {
            case OB_MYSQL: {
                return ConstraintBuilder.getAllConstraintFactoriesMysql(this.dataSource, this.schema, this.tableName, this.totalMockCount);
            }
            case OB_ORACLE: {
                return ConstraintBuilder.getAllConstraintFactoriesOracle(this.dataSource, this.schema, this.tableName, this.totalMockCount);
            }
        }
        return Collections.emptyList();
    }

    private static List<ConstraintFactory> getAllConstraintFactoriesMysql(DataSource dataSource, String schema, String tableName, int totalCount) {
        return Arrays.asList(new OBMysqlUKConstraintFactory(dataSource, schema, tableName, totalCount), new OBMysqlPKConstraintFactory(dataSource, schema, tableName, totalCount));
    }

    private static List<ConstraintFactory> getAllConstraintFactoriesOracle(DataSource dataSource, String schema, String tableName, int totalCount) {
        return Arrays.asList(new OBOracleForeignConstraintFactory(dataSource, schema, tableName), new OBOracleCheckConstraintFactory(dataSource, schema, tableName), new OBOracleUKConstraintFactory(dataSource, schema, tableName, totalCount), new OBOraclePKConstraintFactory(dataSource, schema, tableName, totalCount));
    }

    private static void validateConstraints(List<Constraint> constraints, String tableName, Map<String, AbstractDataType<?, ? extends Comparable<?>>> columnName2DataType, int totalCount) {
        for (Constraint constraint : constraints) {
            Map<String, Integer> cols = constraint.columns().get(tableName);
            Set<String> colSet = cols.keySet();
            Long limitCount = 1L;
            for (String col : colSet) {
                AbstractDataType<?, Comparable<?>> dataType = columnName2DataType.get(col);
                if (dataType == null) {
                    log.warn("Constraint's related column is not found, constraintName={}, colName={}", (Object)constraint.name(), (Object)col);
                    limitCount = totalCount;
                    break;
                }
                Long typeLimit = dataType.distinctLimit();
                if (typeLimit > (long)totalCount) {
                    limitCount = totalCount;
                    break;
                }
                if ((limitCount = Long.valueOf(limitCount * dataType.distinctLimit())) <= (long)totalCount) continue;
                break;
            }
            if (limitCount >= (long)totalCount) continue;
            throw new IllegalArgumentException(String.format("The given data generator can only generate %d unique data for cols {%s}, but the goal is %d", limitCount.intValue(), String.join((CharSequence)", ", colSet), totalCount));
        }
    }

    ConstraintBuilder(ObModeType obModeType, DataSource dataSource, String schema, String tableName, int totalMockCount, Map<String, AbstractDataType<?, ? extends Comparable<?>>> columnName2DataType) {
        this.obModeType = obModeType;
        this.dataSource = dataSource;
        this.schema = schema;
        this.tableName = tableName;
        this.totalMockCount = totalMockCount;
        this.columnName2DataType = columnName2DataType;
    }

    public static ConstraintBuilderBuilder builder() {
        return new ConstraintBuilderBuilder();
    }

    public static class ConstraintBuilderBuilder {
        private ObModeType obModeType;
        private DataSource dataSource;
        private String schema;
        private String tableName;
        private int totalMockCount;
        private Map<String, AbstractDataType<?, ? extends Comparable<?>>> columnName2DataType;

        ConstraintBuilderBuilder() {
        }

        public ConstraintBuilderBuilder obModeType(ObModeType obModeType) {
            this.obModeType = obModeType;
            return this;
        }

        public ConstraintBuilderBuilder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public ConstraintBuilderBuilder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public ConstraintBuilderBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public ConstraintBuilderBuilder totalMockCount(int totalMockCount) {
            this.totalMockCount = totalMockCount;
            return this;
        }

        public ConstraintBuilderBuilder columnName2DataType(Map<String, AbstractDataType<?, ? extends Comparable<?>>> columnName2DataType) {
            this.columnName2DataType = columnName2DataType;
            return this;
        }

        public ConstraintBuilder build() {
            return new ConstraintBuilder(this.obModeType, this.dataSource, this.schema, this.tableName, this.totalMockCount, this.columnName2DataType);
        }

        public String toString() {
            return "ConstraintBuilder.ConstraintBuilderBuilder(obModeType=" + (Object)((Object)this.obModeType) + ", dataSource=" + this.dataSource + ", schema=" + this.schema + ", tableName=" + this.tableName + ", totalMockCount=" + this.totalMockCount + ", columnName2DataType=" + this.columnName2DataType + ")";
        }
    }
}

