/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.constraint;

import com.oceanbase.tools.datamocker.constraint.AbstractUniqueConstraintFactory;
import com.oceanbase.tools.datamocker.model.dbobject.ConstraintColumn;
import com.oceanbase.tools.datamocker.model.dbobject.TableColumn;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import com.oceanbase.tools.datamocker.util.SerializeUtil;
import javax.sql.DataSource;
import lombok.NonNull;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.JdbcTemplate;

class OBMysqlUKConstraintFactory
extends AbstractUniqueConstraintFactory {
    private static final String LIST_CONSTRAINTS_COLS_KEY = "list-constraint-columns";

    public OBMysqlUKConstraintFactory(@NonNull DataSource dataSource, @NonNull String schema, @NonNull String tableName, int totalCount) {
        super(dataSource, schema, tableName, totalCount);
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked @NonNull but is null");
        }
        if (schema == null) {
            throw new NullPointerException("schema is marked @NonNull but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked @NonNull but is null");
        }
    }

    @Override
    protected String getFileName() {
        return "sql/constraint/obmysql.yaml";
    }

    @Override
    protected String getListConstraintsKey() {
        return "list-unique-constraints";
    }

    @Override
    protected void checkVirtualColumn(DataSource dataSource, ConstraintColumn constraintColumn) {
        String content = OBMysqlUKConstraintFactory.getSqlContent(this.getFileName(), LIST_CONSTRAINTS_COLS_KEY);
        Boolean result = (Boolean)new JdbcTemplate(dataSource).query(content, ps -> {
            ps.setString(1, constraintColumn.getOwner());
            ps.setString(2, constraintColumn.getColumnName());
            ps.setString(3, constraintColumn.getTableName());
        }, rs -> {
            try {
                TableColumn tableCol = SerializeUtil.getObject(rs, TableColumn.class);
                if (tableCol == null) {
                    return false;
                }
                return StringUtils.isBlank((String)tableCol.getExpression());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException(e);
            }
        });
        if (Boolean.FALSE.equals(result)) {
            String msg = String.format("Virtual column \"%s.%s\" for constraint is not support yet", constraintColumn.getTableName(), constraintColumn.getColumnName());
            throw new MockerException(MockerError.NOT_SUPPORT_FEATURE, msg);
        }
    }
}

