/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.constraint;

import com.oceanbase.tools.datamocker.constraint.AbstractConstraintFactory;
import com.oceanbase.tools.datamocker.constraint.Constraint;
import com.oceanbase.tools.datamocker.model.dbobject.ConstraintColumn;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import com.oceanbase.tools.datamocker.util.SerializeUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import lombok.NonNull;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.CollectionUtils;

class OBOracleForeignConstraintFactory
extends AbstractConstraintFactory {
    public OBOracleForeignConstraintFactory(@NonNull DataSource dataSource, @NonNull String schema, @NonNull String tableName) {
        super(dataSource, schema, tableName);
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked @NonNull but is null");
        }
        if (schema == null) {
            throw new NullPointerException("schema is marked @NonNull but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked @NonNull but is null");
        }
    }

    @Override
    protected List<Constraint> doGenerate(String querySql, DataSource dataSource, String schema, String tableName) {
        List columns = (List)new JdbcTemplate(dataSource).query(querySql, ps -> {
            ps.setString(1, schema);
            ps.setString(2, tableName);
        }, rs -> {
            try {
                return SerializeUtil.getList(rs, ConstraintColumn.class);
            }
            catch (IllegalAccessException | InstantiationException e) {
                return Collections.emptyList();
            }
        });
        if (!CollectionUtils.isEmpty((Collection)columns)) {
            throw new MockerException(MockerError.NOT_SUPPORT_FEATURE, "Foreign constraint is not support yet");
        }
        return Collections.emptyList();
    }

    @Override
    protected String getFileName() {
        return "sql/constraint/oboracle.yaml";
    }

    @Override
    protected String getListConstraintsKey() {
        return "list-foreign-constraints";
    }
}

