/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.constraint;

import com.oceanbase.tools.datamocker.constraint.Constraint;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import com.oceanbase.tools.datamocker.model.mock.MockColumnData;
import com.oceanbase.tools.datamocker.model.mock.MockRowData;
import com.oceanbase.tools.datamocker.util.DuplicatedJudger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueConstraint
implements Constraint {
    private static final Logger log = LoggerFactory.getLogger(UniqueConstraint.class);
    private final String constraintName;
    private final String tableName;
    private final DuplicatedJudger judger;
    private final Map<String, Map<String, Integer>> tableName2ConstraintColumns;
    private final List<String> sortedList;

    public UniqueConstraint(@NonNull String constraintName, @NonNull String tableName, @NonNull Map<String, Map<String, Integer>> consColumns, int count) {
        if (constraintName == null) {
            throw new NullPointerException("constraintName is marked @NonNull but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked @NonNull but is null");
        }
        if (consColumns == null) {
            throw new NullPointerException("consColumns is marked @NonNull but is null");
        }
        Validate.isTrue((count > 0 ? 1 : 0) != 0, (String)"Count for UniqueConstraint can not be negative");
        this.constraintName = constraintName;
        this.tableName = tableName;
        this.tableName2ConstraintColumns = consColumns;
        this.judger = new DuplicatedJudger(count);
        this.sortedList = UniqueConstraint.sortMapByValue(UniqueConstraint.validateConsColumns(tableName, consColumns));
    }

    @Override
    public boolean mark(MockRowData value) {
        if (value == null || value.columnNum() == 0) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Value can not be null for mark method");
        }
        UniqueConstraint.validateConsColumns(this.tableName, this.tableName2ConstraintColumns);
        return this.doCheck(value, true);
    }

    @Override
    public boolean check(MockRowData rowData) {
        if (rowData == null || rowData.columnNum() == 0) {
            return false;
        }
        Map<String, Integer> columns = UniqueConstraint.validateConsColumns(this.tableName, this.tableName2ConstraintColumns);
        this.validateInput(columns, rowData);
        return this.doCheck(rowData, false);
    }

    @Override
    public String name() {
        return this.constraintName;
    }

    @Override
    public Map<String, Map<String, Integer>> columns() {
        return this.tableName2ConstraintColumns;
    }

    protected boolean doCheck(MockRowData value, Boolean markable) {
        String checkValue = this.convertFromRowDataToStringListData(value);
        if (this.judger.contains(checkValue)) {
            return false;
        }
        if (markable.booleanValue() && !this.judger.add(checkValue)) {
            log.warn("Fail to add row to DuplicatedJudger, row={}", (Object)checkValue);
        }
        return true;
    }

    private void validateInput(Map<String, Integer> columns, MockRowData mockRowData) {
        Set<String> initCons = columns.keySet();
        Set<String> valueCons = mockRowData.columnNames();
        if (initCons.stream().anyMatch(s -> !valueCons.contains(s))) {
            String errMsg = String.format("Input constraint's columns must contain init constraint's columns, [%s]!=[%s]", String.join((CharSequence)",", initCons), String.join((CharSequence)",", valueCons));
            throw new MockerException(MockerError.PARAMETER_ERROR, errMsg);
        }
    }

    private static List<String> sortMapByValue(Map<String, Integer> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        ArrayList<Map.Entry<String, Integer>> entryList = new ArrayList<Map.Entry<String, Integer>>(map.entrySet());
        entryList.sort(Map.Entry.comparingByValue());
        return entryList.stream().map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private static Map<String, Integer> validateConsColumns(String table, Map<String, Map<String, Integer>> consColumns) {
        Map<String, Integer> columns = consColumns.get(table);
        if (columns == null) {
            throw new MockerException(MockerError.PARAMETER_ERROR, String.format("Constraint columns for table \"%s\" can not be null or empty", table));
        }
        return columns;
    }

    private String convertFromRowDataToStringListData(MockRowData mockRowData) {
        return this.sortedList.stream().map(s -> {
            MockColumnData<?> mockColumn = mockRowData.getMockColumn((String)s);
            if (mockColumn == null) {
                throw new MockerException(MockerError.OPERATION_FAILURE, "Data for unique constraint have to have same column list \"%s\"" + String.join((CharSequence)",", this.sortedList));
            }
            return mockColumn.toDigestString();
        }).collect(Collectors.joining(","));
    }
}

