/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.core;

import com.oceanbase.tools.datamocker.model.config.DataBaseConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.NonNull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class DataSourceFactory {
    private static final String JDBC_DRIVER_CLASS = "com.oceanbase.jdbc.Driver";
    private final DataBaseConfig config;
    private String driverClassName;
    private String protocolName;
    private String connectionInitSql;
    private int maxPoolSize;
    private Long timeoutMillis;
    private Map<String, String> params;

    public DataSourceFactory(@NonNull DataBaseConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        this.validate(config);
        this.config = config;
        this.params = config.getConnectParam();
    }

    public DataSource generate() throws SQLException {
        HikariDataSource dataSource = new HikariDataSource();
        if ("jdbc:oceanbase".equals(this.getProtocolName())) {
            long timeoutUs;
            String initSql = "set session ob_query_timeout=180000000;set session ob_trx_timeout=180000000;";
            if (this.timeoutMillis != null && this.timeoutMillis > 0L && (timeoutUs = this.timeoutMillis * 1000L) > 0L) {
                initSql = "set session ob_query_timeout=" + timeoutUs + ";set session ob_trx_timeout=" + timeoutUs + ";";
            }
            this.connectionInitSql = StringUtils.isEmpty((String)this.connectionInitSql) ? initSql : initSql + this.connectionInitSql;
            if (this.params == null) {
                this.params = new HashMap<String, String>();
            }
            this.params.putIfAbsent("allowMultiQueries", "true");
        }
        dataSource.setConnectionInitSql(this.connectionInitSql);
        dataSource.setJdbcUrl(this.getJdbcUrl());
        dataSource.setAutoCommit(true);
        dataSource.setUsername(this.getUsername());
        if (StringUtils.isEmpty((String)this.driverClassName)) {
            dataSource.setDriverClassName(JDBC_DRIVER_CLASS);
        } else {
            dataSource.setDriverClassName(this.driverClassName);
        }
        if (StringUtils.isEmpty((String)this.config.getPassword())) {
            dataSource.setPassword("");
        } else {
            dataSource.setPassword(this.config.getPassword());
        }
        this.init(dataSource);
        return dataSource;
    }

    public String getProtocolName() {
        return StringUtils.isEmpty((String)this.protocolName) ? "jdbc:oceanbase" : this.protocolName;
    }

    private void validate(DataBaseConfig config) {
        Validate.notNull((Object)config.getUser(), (String)"User can not be empty");
        Validate.notNull((Object)config.getHost(), (String)"Host can not be empty");
        Validate.notNull((Object)config.getPort(), (String)"Port can not be empty");
        Validate.notEmpty((String)config.getDefaultSchame(), (String)"DefaultSchema can not be empty");
    }

    private void init(HikariDataSource dataSource) throws SQLException {
        dataSource.setLoginTimeout(15);
        dataSource.setMaximumPoolSize(5);
        if (this.maxPoolSize > 0) {
            dataSource.setMaximumPoolSize(this.maxPoolSize);
        }
    }

    private String getJdbcUrl() {
        StringBuilder buffer = new StringBuilder(this.getProtocolName());
        buffer.append("://").append(this.config.getHost()).append(":").append(this.config.getPort()).append("/").append(this.config.getDefaultSchame());
        if (this.params != null) {
            Set<Map.Entry<String, String>> entrySet = this.params.entrySet();
            String paramStr = entrySet.stream().map(stringStringEntry -> (String)stringStringEntry.getKey() + "=" + (String)stringStringEntry.getValue()).collect(Collectors.joining("&"));
            buffer.append("?").append(paramStr);
        }
        return buffer.toString();
    }

    private String getUsername() {
        StringBuilder username = new StringBuilder(this.config.getUser());
        if (StringUtils.isNotBlank((String)this.config.getTenant())) {
            username.append("@").append(this.config.getTenant());
        }
        if (StringUtils.isNotBlank((String)this.config.getCluster())) {
            username.append("#").append(this.config.getCluster());
        }
        return username.toString();
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public void setProtocolName(String protocolName) {
        this.protocolName = protocolName;
    }

    public void setConnectionInitSql(String connectionInitSql) {
        this.connectionInitSql = connectionInitSql;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setTimeoutMillis(Long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }
}

