/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.core;

import com.oceanbase.tools.datamocker.core.TopNode;
import java.util.concurrent.locks.ReentrantLock;
import lombok.NonNull;
import org.apache.commons.lang.Validate;

public class Dispatcher<T> {
    private final String logDir;
    private final ReentrantLock lock = new ReentrantLock();
    private int width;
    private TopNode<T>[] queuePointers;

    public Dispatcher(@NonNull String logDir) {
        if (logDir == null) {
            throw new NullPointerException("logDir is marked @NonNull but is null");
        }
        this.width = 0;
        this.logDir = logDir;
    }

    public Dispatcher(int width, @NonNull String logDir) {
        if (logDir == null) {
            throw new NullPointerException("logDir is marked @NonNull but is null");
        }
        Validate.isTrue((width > 0 ? 1 : 0) != 0, (String)"Width can not be negative");
        this.logDir = logDir;
        this.width = width;
        this.queuePointers = new TopNode[width];
        for (int i = 0; i < width; ++i) {
            this.queuePointers[i] = new TopNode();
        }
    }

    public int getTotalCount() {
        int queueSize = this.getWidth();
        int returnVal = 0;
        for (int i = 0; i < queueSize; ++i) {
            returnVal += this.getTaskSize(i);
        }
        return returnVal;
    }

    public int getTaskSize(int index) {
        if (index >= this.width || index < 0) {
            throw new IllegalArgumentException(String.format("Index %d out of bound [0,%d)", index, this.width));
        }
        TopNode<T> topNode = this.queuePointers[index];
        return topNode.length;
    }

    public T getObj(int index, int columnIndex) {
        if (index >= this.width || index < 0) {
            throw new IllegalArgumentException(String.format("Index %d out of bound [0,%d)", index, this.width));
        }
        TopNode<T> topNode = this.queuePointers[index];
        if (columnIndex >= topNode.length) {
            return null;
        }
        Node destNode = topNode.downNext;
        while (destNode != null && columnIndex-- != 0) {
            destNode = destNode.downNext;
        }
        if (destNode == null) {
            throw new NullPointerException("Can't find data node");
        }
        return destNode.getObj();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T pop(int index) {
        if (index >= this.width || index < 0) {
            throw new IllegalArgumentException(String.format("Index %d out of bound [0,%d)", index, this.width));
        }
        TopNode<T> topNode = this.queuePointers[index];
        if (topNode.length <= 0) {
            return null;
        }
        T returnObj = null;
        topNode.writeLock.lock();
        try {
            Node next;
            Node destNode;
            if (topNode.length != 0 && (destNode = topNode.downNext) != null) {
                returnObj = destNode.getObj();
            }
            if ((next = topNode.downNext) != null) {
                topNode.downNext = next.downNext;
                next.downNext = null;
            }
            if (topNode.length > 0) {
                --topNode.length;
            }
        }
        finally {
            topNode.writeLock.unlock();
        }
        return returnObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObj(int index, T obj) {
        if (obj == null) {
            return;
        }
        if (index < this.width) {
            TopNode<T> topNode = this.queuePointers[index];
            if (topNode == null) {
                throw new IllegalArgumentException(String.format("Index %d is invaild", index));
            }
            topNode.writeLock.lock();
            try {
                Node lastNode = topNode.downNext;
                if (lastNode != null) {
                    while (lastNode.downNext != null) {
                        lastNode = lastNode.downNext;
                    }
                }
                Node newNode = new Node(obj);
                if (lastNode == null) {
                    topNode.downNext = newNode;
                } else {
                    lastNode.downNext = newNode;
                }
                lastNode = newNode;
                lastNode.downNext = null;
                ++topNode.length;
            }
            finally {
                topNode.writeLock.unlock();
            }
        }
        if (index == this.width) {
            this.lock.lock();
            try {
                if (index == this.width) {
                    ++this.width;
                    TopNode[] newTopNodes = new TopNode[this.width];
                    for (int i = 0; i < this.width - 1; ++i) {
                        newTopNodes[i] = this.queuePointers[i];
                    }
                    newTopNodes[this.width - 1] = new TopNode();
                    this.queuePointers = newTopNodes;
                }
            }
            finally {
                this.lock.unlock();
            }
            this.setObj(index, obj);
        } else {
            throw new IllegalArgumentException(String.format("Index %d out of bound", index));
        }
    }

    public String getLogDir() {
        return this.logDir;
    }

    public int getWidth() {
        return this.width;
    }

    class Node {
        private T obj = null;
        public Node downNext = null;
        public ReentrantLock readLock;
        public ReentrantLock writeLock;

        public Node(T obj) {
            this.obj = obj;
            this.readLock = new ReentrantLock();
            this.writeLock = new ReentrantLock();
        }

        public T getObj() {
            return this.obj;
        }
    }
}

