/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.core.read;

import com.oceanbase.tools.datamocker.datatype.AbstractDataType;
import com.oceanbase.tools.datamocker.model.mock.MockColumnData;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnReader<T> {
    private static final Logger log = LoggerFactory.getLogger(ColumnReader.class);
    private final String columnName;
    private final String groupId;
    private final AbstractDataType<T, ? extends Comparable<?>> dataType;

    public ColumnReader(@NonNull AbstractDataType<T, ? extends Comparable<?>> dataType, @NonNull String columnName, String groupId) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked @NonNull but is null");
        }
        if (columnName == null) {
            throw new NullPointerException("columnName is marked @NonNull but is null");
        }
        this.dataType = dataType;
        this.columnName = columnName;
        this.groupId = groupId;
    }

    public String groupId() {
        return this.groupId;
    }

    public MockColumnData<T> read() {
        return new MockColumnData<T>(this.columnName, this.dataType, this.dataType.acquire());
    }

    public String getColumnName() {
        return this.columnName;
    }
}

