/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.core.task;

import com.oceanbase.tools.datamocker.core.task.AbstractCallBack;
import com.oceanbase.tools.datamocker.core.task.TableTaskContext;
import com.oceanbase.tools.datamocker.core.task.TableTaskMetaData;
import com.oceanbase.tools.datamocker.model.enums.MockTaskStatus;
import java.util.concurrent.Callable;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class AbstractMockTask
implements Callable<Void> {
    private static final Logger log = LoggerFactory.getLogger(AbstractMockTask.class);
    private final long startTimeStamp;
    private final TableTaskMetaData metaData;
    private final TableTaskContext context;
    private AbstractCallBack<TableTaskContext> callBack;
    private volatile boolean cancelled = false;

    public AbstractMockTask(@NonNull TableTaskMetaData metaData, @NonNull TableTaskContext context) {
        if (metaData == null) {
            throw new NullPointerException("metaData is marked @NonNull but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked @NonNull but is null");
        }
        this.metaData = metaData;
        this.context = context;
        this.startTimeStamp = System.currentTimeMillis();
    }

    public abstract void execute(TableTaskMetaData var1, TableTaskContext var2) throws Exception;

    @Override
    public Void call() {
        try {
            if (this.isCancelled()) {
                return null;
            }
            MDC.put((String)"mocktask.workspace", (String)this.metaData.getLogDir());
            this.execute(this.metaData, this.context);
            if (this.callBack != null) {
                try {
                    this.callBack.onSuccess(this.context);
                }
                catch (Throwable e) {
                    boolean shutdownResult = this.context.terminate();
                    this.context.setStatus(MockTaskStatus.FAILED);
                    log.warn("Failed to call onSuccess, result={}", (Object)shutdownResult, (Object)e);
                }
            }
            return null;
        }
        catch (Throwable e) {
            log.warn("Failed to execute mock data task, message={}", (Object)e.getMessage());
            Throwable exception = e;
            while (!(exception instanceof InterruptedException) && (exception = exception.getCause()) != null) {
            }
            if (exception != null) {
                if (MockTaskStatus.CANCELED.equals((Object)this.context.getStatus())) {
                    log.warn("Mock data task is interrupted, duration={}ms,status={}", (Object)this.interval(), (Object)this.context.getStatus());
                } else {
                    this.context.setStatus(MockTaskStatus.FAILED);
                }
            } else if (!MockTaskStatus.CANCELED.equals((Object)this.context.getStatus())) {
                this.context.setStatus(MockTaskStatus.FAILED);
            }
            this.context.terminate();
            if (this.callBack != null) {
                MockTaskStatus finalStatus = this.context.getStatus();
                try {
                    this.callBack.onFailure(this.context, e);
                }
                catch (Throwable e1) {
                    log.warn("Failed to call onFailure call back method, status={}", (Object)finalStatus, (Object)e);
                }
                this.context.setStatus(finalStatus);
            }
            return null;
        }
    }

    public void cancel() {
        this.cancelled = true;
    }

    public boolean isCancelled() {
        return Thread.currentThread().isInterrupted() || this.cancelled;
    }

    protected long interval() {
        return System.currentTimeMillis() - this.startTimeStamp;
    }

    protected long startTime() {
        return this.startTimeStamp;
    }

    public void bind(AbstractCallBack<TableTaskContext> callBack) {
        this.callBack = callBack;
    }
}

