/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.core.task;

import com.oceanbase.tools.datamocker.core.write.DataWriter;
import com.oceanbase.tools.datamocker.model.mock.MockColumnData;
import com.oceanbase.tools.datamocker.model.mock.MockRowData;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.NonNull;
import org.springframework.util.CollectionUtils;

class ConcurrentDataWriter
implements DataWriter {
    private long awaitMillis = 15000L;
    private volatile List<MockRowData> targets = null;
    private final List<DataWriter> dataWriters;
    private final Integer threadCount;
    private final Lock writeLock = new ReentrantLock();
    private final Condition notAllThreadsReady = this.writeLock.newCondition();
    private volatile Integer counter;
    private volatile boolean closed = false;

    public ConcurrentDataWriter(int threadCount, @NonNull List<DataWriter> dataWriters) {
        if (dataWriters == null) {
            throw new NullPointerException("dataWriters is marked @NonNull but is null");
        }
        this.dataWriters = dataWriters;
        this.threadCount = threadCount;
        this.init();
    }

    @Override
    public long write(List<MockRowData> rows) {
        if (this.closed) {
            throw new IllegalStateException("DataWriter has been closed");
        }
        try {
            if (!this.writeLock.tryLock(this.awaitMillis, TimeUnit.MILLISECONDS)) {
                throw new IllegalStateException("Failed to get lock for " + this.awaitMillis + "ms");
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        try {
            if (this.targets == null) {
                this.targets = rows;
            } else {
                if (this.targets.size() != rows.size()) {
                    throw new IllegalStateException(String.format("Target's size != row's size, %s!=%s", this.targets.size(), rows.size()));
                }
                int len2 = rows.size();
                for (int i = 0; i < len2; ++i) {
                    MockRowData row = this.targets.get(i);
                    rows.get(i).getMockColumns().forEach(c -> this.writeRow(row, (MockColumnData<?>)c));
                }
            }
            ConcurrentDataWriter len2 = this;
            len2.counter = len2.counter - 1;
            if (len2.counter > 0) {
                this.notAllThreadsReady.await(this.awaitMillis, TimeUnit.MILLISECONDS);
                long len2 = 0L;
                return len2;
            }
            this.counter = this.threadCount;
            this.notAllThreadsReady.signalAll();
            long len2 = this.write();
            return len2;
        }
        catch (Exception e) {
            this.init();
            throw new IllegalStateException(e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        this.dataWriters.forEach(dataWriter -> {
            try {
                dataWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private void writeRow(MockRowData row, MockColumnData<?> target) {
        String columName = target.getColumnName();
        if (row.getMockColumn(columName) != null) {
            throw new IllegalArgumentException(String.format("Custom column \"%s\" is duplicate", columName));
        }
        row.addMockColumn(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long write() {
        if (CollectionUtils.isEmpty(this.targets)) {
            return 0L;
        }
        try {
            AtomicInteger errCounter = new AtomicInteger(0);
            long total = this.dataWriters.stream().map(dataWriter -> {
                try {
                    return dataWriter.write(this.targets);
                }
                catch (Exception e) {
                    errCounter.incrementAndGet();
                    return 0L;
                }
            }).mapToLong(value -> value).sum();
            if (errCounter.intValue() > 0) {
                long l = errCounter.intValue() * -1;
                return l;
            }
            long l = total;
            return l;
        }
        finally {
            this.targets = null;
        }
    }

    private void init() {
        if (!this.writeLock.tryLock()) {
            throw new IllegalStateException("Failed to init, reason: failed to lock");
        }
        try {
            this.counter = this.threadCount;
            this.targets = null;
            this.notAllThreadsReady.signalAll();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setAwaitMillis(long awaitMillis) {
        this.awaitMillis = awaitMillis;
    }
}

