/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.core.task;

import com.oceanbase.tools.datamocker.core.DataSourceFactory;
import com.oceanbase.tools.datamocker.core.task.AbstractMockTask;
import com.oceanbase.tools.datamocker.core.task.TableTaskContext;
import com.oceanbase.tools.datamocker.core.task.TableTaskMetaData;
import com.oceanbase.tools.dbbrowser.util.SqlBuilder;
import javax.sql.DataSource;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class MockDataBeforeTask
extends AbstractMockTask {
    private static final Logger log = LoggerFactory.getLogger(MockDataBeforeTask.class);
    private final SqlBuilder sqlBuilder;
    private final DataSourceFactory factory;

    public MockDataBeforeTask(TableTaskMetaData metaData, TableTaskContext context, @NonNull SqlBuilder sqlBuilder, @NonNull DataSourceFactory dataSourceFactory) {
        super(metaData, context);
        if (sqlBuilder == null) {
            throw new NullPointerException("sqlBuilder is marked @NonNull but is null");
        }
        if (dataSourceFactory == null) {
            throw new NullPointerException("dataSourceFactory is marked @NonNull but is null");
        }
        this.sqlBuilder = sqlBuilder;
        this.factory = dataSourceFactory;
    }

    @Override
    public void execute(TableTaskMetaData metaData, TableTaskContext context) throws Exception {
        log.info("Mock before task is running...");
        if (!Boolean.TRUE.equals(metaData.getShouldTruncate())) {
            log.info("Mock before task is succeed");
            return;
        }
        this.sqlBuilder.append((CharSequence)"DELETE FROM ").identifier(metaData.getSchema()).append((CharSequence)".").identifier(metaData.getTableName()).append((CharSequence)" WHERE 1=1");
        DataSource dataSource = this.factory.generate();
        try {
            new JdbcTemplate(dataSource).execute(this.sqlBuilder.toString());
        }
        catch (Exception e) {
            log.warn("Failed to truncate table, sql={}", (Object)this.sqlBuilder.toString(), (Object)e);
            throw e;
        }
        finally {
            if (dataSource instanceof AutoCloseable) {
                ((AutoCloseable)((Object)dataSource)).close();
            }
        }
        log.info("Mock before task is succeed");
    }
}

