/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.core.task;

import com.oceanbase.tools.datamocker.constraint.Constraint;
import com.oceanbase.tools.datamocker.core.read.ColumnReader;
import com.oceanbase.tools.datamocker.core.task.AbstractMockTask;
import com.oceanbase.tools.datamocker.core.task.TableTaskContext;
import com.oceanbase.tools.datamocker.core.task.TableTaskMetaData;
import com.oceanbase.tools.datamocker.core.write.DataWriter;
import com.oceanbase.tools.datamocker.model.mock.MockColumnData;
import com.oceanbase.tools.datamocker.model.mock.MockRowData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockDataTask
extends AbstractMockTask {
    private static final Logger log = LoggerFactory.getLogger(MockDataTask.class);
    private final DataWriter dataWriter;
    private final List<ColumnReader<?>> readers;
    private final List<Constraint> constraints;
    private Integer failedWriteBatchCount = 0;

    public MockDataTask(TableTaskMetaData metaData, TableTaskContext context, @NonNull DataWriter dataWriter, @NonNull List<ColumnReader<?>> readers, @NonNull List<Constraint> constraints) {
        super(metaData, context);
        if (dataWriter == null) {
            throw new NullPointerException("dataWriter is marked @NonNull but is null");
        }
        if (readers == null) {
            throw new NullPointerException("readers is marked @NonNull but is null");
        }
        if (constraints == null) {
            throw new NullPointerException("constraints is marked @NonNull but is null");
        }
        this.readers = readers;
        this.dataWriter = dataWriter;
        this.constraints = constraints.stream().filter(c -> {
            Set<String> colSet = c.columns().get(metaData.getTableName()).keySet();
            return readers.stream().anyMatch(r -> colSet.contains(r.getColumnName()));
        }).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(TableTaskMetaData metaData, TableTaskContext context) throws Exception {
        log.info("Mock data task is running... constraintName={}, columnName={}", this.constraints.stream().map(Constraint::name).collect(Collectors.toList()), this.readers.stream().map(ColumnReader::getColumnName).collect(Collectors.toList()));
        long counter = 0L;
        long emptyLoopCount = 0L;
        long batchSize = metaData.getBatchSize() * (long)metaData.getConcurrent().intValue();
        ArrayList<MockRowData> batchList = new ArrayList<MockRowData>(Long.valueOf(batchSize).intValue() + 10);
        try {
            while (counter++ < metaData.getTotalCount() && !this.isCancelled() && this.interval() <= metaData.getTimeoutMillis()) {
                if ((long)batchList.size() >= batchSize) {
                    context.accumulateGenerateCountAndGet(batchList.size());
                    long len = this.writeBatch(batchList, context);
                    batchList = new ArrayList(Long.valueOf(batchSize).intValue() + 10);
                    if (len < 0L) {
                        Iterator<Constraint> iterator = this;
                        Integer n = ((MockDataTask)((Object)iterator)).failedWriteBatchCount;
                        Integer n2 = ((MockDataTask)((Object)iterator)).failedWriteBatchCount = Integer.valueOf(((MockDataTask)((Object)iterator)).failedWriteBatchCount + 1);
                    }
                    if (this.reachMaxErrors(metaData)) break;
                }
                MockRowData mockRowData = new MockRowData(this.readers.size());
                for (ColumnReader<?> item : this.readers) {
                    MockColumnData<?> mockColumn = item.read();
                    mockRowData.addMockColumn(mockColumn);
                }
                boolean passCheck = true;
                ++emptyLoopCount;
                for (Constraint constraint : this.constraints) {
                    if (constraint.check(mockRowData)) continue;
                    passCheck = false;
                    --counter;
                    break;
                }
                if (passCheck) {
                    emptyLoopCount = 0L;
                    batchList.add(mockRowData);
                    for (Constraint constraint : this.constraints) {
                        constraint.mark(mockRowData);
                    }
                }
                if (emptyLoopCount <= metaData.getTotalCount() * 100L && emptyLoopCount <= 1000000L) continue;
                throw new IllegalStateException(String.format("Data generation cycle idling %d exceeds the maximum number of data generation %d, too much data cannot pass the constraint check, data generation is terminated", emptyLoopCount, metaData.getTotalCount() * 100L));
            }
            --counter;
        }
        catch (Exception e) {
            log.warn("Mock data task is failed", (Throwable)e);
            throw e;
        }
        finally {
            try {
                context.accumulateGenerateCountAndGet(batchList.size());
                this.writeBatch(batchList, context);
            }
            catch (Exception exception) {
            }
            finally {
                this.dataWriter.close();
            }
        }
        long writeCount = context.getTotalWriteCountByCurrentThread();
        if (this.isCancelled()) {
            log.warn("Mock data task is cancelled, totalGenerate={}, totalWrite={}, duration={}", new Object[]{counter, writeCount, DurationFormatUtils.formatDurationHMS((long)this.interval())});
            throw new InterruptedException("Mock data task has been interrupted");
        }
        if (this.interval() >= metaData.getTimeoutMillis()) {
            log.warn("Mock data task is timeout, totalGenerate={}, totalWrite={}, duration={}", new Object[]{counter, writeCount, DurationFormatUtils.formatDurationHMS((long)this.interval())});
        }
        if (counter >= metaData.getTotalCount()) {
            log.info("Mock data task is succeed, totalGenerate={}, totalWrite={}, duration={}", new Object[]{counter, writeCount, DurationFormatUtils.formatDurationHMS((long)this.interval())});
        }
    }

    private long writeBatch(List<MockRowData> batchList, TableTaskContext context) {
        if (this.dataWriter.isClosed()) {
            throw new IllegalStateException("DataWriter has been closed");
        }
        try {
            long len = this.dataWriter.write(batchList);
            if (len > 0L) {
                context.accumulateWriteCountAndGet(batchList.size());
            }
            return len;
        }
        catch (Exception e) {
            context.accumulateWriteCountAndGet(0L);
            log.warn("Failed to write a batch, batchListSize={}", (Object)batchList.size(), (Object)e);
            return -1L;
        }
    }

    private boolean reachMaxErrors(TableTaskMetaData metaData) {
        if (metaData.getMaxErrors() <= 0) {
            return false;
        }
        return this.failedWriteBatchCount >= metaData.getMaxErrors();
    }
}

