/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.core.task;

import com.oceanbase.tools.datamocker.core.task.AbstractCallBack;
import com.oceanbase.tools.datamocker.core.task.AbstractMockTask;
import com.oceanbase.tools.datamocker.core.task.ConcurrentDataWriter;
import com.oceanbase.tools.datamocker.core.task.MockDataAfterTask;
import com.oceanbase.tools.datamocker.core.task.MockDataBeforeTask;
import com.oceanbase.tools.datamocker.core.task.MockDataTask;
import com.oceanbase.tools.datamocker.core.task.TableTaskContext;
import com.oceanbase.tools.datamocker.core.task.TableTaskInfo;
import com.oceanbase.tools.datamocker.model.enums.MockTaskStatus;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import com.oceanbase.tools.datamocker.schedule.MockExecutorService;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableTask {
    private static final Logger log = LoggerFactory.getLogger(TableTask.class);
    private final TableTaskContext context;
    private final AbstractMockTask beforeTask;
    private final AbstractMockTask afterTask;
    private final List<AbstractMockTask> businessTasks;
    private final AtomicInteger counter = new AtomicInteger(0);

    public TableTask(@NonNull TableTaskInfo tableTaskInfo, @NonNull Set<Set<String>> columnGroups, int index) {
        if (tableTaskInfo == null) {
            throw new NullPointerException("tableTaskInfo is marked @NonNull but is null");
        }
        if (columnGroups == null) {
            throw new NullPointerException("columnGroups is marked @NonNull but is null");
        }
        this.context = new TableTaskContext(tableTaskInfo, index);
        ConcurrentDataWriter dataWriter = new ConcurrentDataWriter(columnGroups.size(), tableTaskInfo.getDataWriters());
        this.businessTasks = columnGroups.stream().map(gs -> new MockDataTask(tableTaskInfo.getMetaData(), this.context, dataWriter, tableTaskInfo.getColumnReaders().stream().filter(r -> gs.contains(r.groupId())).collect(Collectors.toList()), tableTaskInfo.getConstraints())).collect(Collectors.toList());
        this.beforeTask = new MockDataBeforeTask(tableTaskInfo.getMetaData(), this.context, tableTaskInfo.getSqlBuilderSupplier().get(), tableTaskInfo.getDataSourceFactory());
        this.afterTask = new MockDataAfterTask(tableTaskInfo.getMetaData(), this.context);
        this.context.appendHandle(this.beforeTask);
        this.context.appendHandle(this.businessTasks);
        this.context.appendHandle(this.afterTask);
    }

    public void init(final @NonNull MockExecutorService service, final @NonNull AbstractCallBack<TableTaskContext> callBack) {
        if (service == null) {
            throw new NullPointerException("service is marked @NonNull but is null");
        }
        if (callBack == null) {
            throw new NullPointerException("callBack is marked @NonNull but is null");
        }
        final TableTask that = this;
        this.beforeTask.bind(new AbstractCallBack<TableTaskContext>(){

            @Override
            public void doOnSuccess(TableTaskContext param) throws Throwable {
                if (service.isShutdown() || TableTask.this.context.isShutdown() || that.businessTasks.stream().anyMatch(AbstractMockTask::isCancelled)) {
                    log.warn("Mock task has been cancelled, and the mock data task will exit");
                    callBack.onFailure(param, new MockerException("Thread pool has been shutdown"));
                } else {
                    for (AbstractMockTask task : that.businessTasks) {
                        service.submitCallable(task, param);
                    }
                }
            }

            @Override
            public void doOnFailure(TableTaskContext param, Throwable e) throws Throwable {
                callBack.onFailure(param, e);
            }
        });
        for (AbstractMockTask businessTask : this.businessTasks) {
            businessTask.bind(new AbstractCallBack<TableTaskContext>(){

                @Override
                public void doOnSuccess(TableTaskContext param) throws Throwable {
                    TableTask.this.startAfterTask(service, callBack);
                }

                @Override
                public void doOnFailure(TableTaskContext param, Throwable e) throws Throwable {
                    TableTask.this.startAfterTask(service, callBack);
                }
            });
        }
        this.afterTask.bind(new AbstractCallBack<TableTaskContext>(){

            @Override
            public void doOnSuccess(TableTaskContext param) throws Throwable {
                callBack.onSuccess(param);
                if (!MockTaskStatus.FAILED.equals((Object)that.getStatus()) && !MockTaskStatus.CANCELED.equals((Object)that.getStatus())) {
                    param.setStatus(MockTaskStatus.SUCCESS);
                }
            }

            @Override
            public void doOnFailure(TableTaskContext param, Throwable e) throws Throwable {
                callBack.onFailure(param, e);
            }
        });
    }

    private void startAfterTask(MockExecutorService service, AbstractCallBack<TableTaskContext> callBack) throws Throwable {
        if (this.counter.incrementAndGet() == this.businessTasks.size()) {
            if (!service.isShutdown() && !this.context.isShutdown() && this.businessTasks.stream().noneMatch(AbstractMockTask::isCancelled)) {
                service.submitCallable(this.afterTask, this.context);
            } else {
                log.warn("The thread pool has been closed, and the mock data task will exit");
                callBack.onFailure(this.context, new MockerException("Thread pool has been shutdown"));
            }
        }
    }

    public MockTaskStatus getStatus() {
        return this.context.getStatus();
    }

    public TableTaskContext getContext() {
        return this.context;
    }

    public AbstractMockTask getBeforeTask() {
        return this.beforeTask;
    }
}

