/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.core.task;

import com.oceanbase.tools.datamocker.core.task.AbstractMockTask;
import com.oceanbase.tools.datamocker.core.task.TableTaskInfo;
import com.oceanbase.tools.datamocker.core.task.TableTaskMetaData;
import com.oceanbase.tools.datamocker.core.write.SqlScriptOutput;
import com.oceanbase.tools.datamocker.datatype.AbstractDataType;
import com.oceanbase.tools.datamocker.model.enums.MockTaskStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import lombok.NonNull;

public class TableTaskContext {
    private final Long batchSize;
    private final Long totalCount;
    private final Map<String, AbstractDataType<?, ? extends Comparable<?>>> tableSchema;
    private final String tableName;
    private final String schema;
    private final Boolean truncate;
    private final Long timeoutMilliseconds;
    private final List<Future<?>> handlers;
    private final Map<String, Long> threadName2WriteCount;
    private final Map<String, Long> threadName2GenerateCount;
    private final int topIndex;
    private final SqlScriptOutput output;
    private final List<AbstractMockTask> tableTasks;
    private volatile boolean shutdown;
    private volatile MockTaskStatus status;

    public TableTaskContext(@NonNull TableTaskInfo taskInfo, int index) {
        if (taskInfo == null) {
            throw new NullPointerException("taskInfo is marked @NonNull but is null");
        }
        TableTaskMetaData metaData = taskInfo.getMetaData();
        this.output = taskInfo.getOutput();
        this.topIndex = index;
        this.batchSize = metaData.getBatchSize();
        this.totalCount = metaData.getTotalCount();
        this.tableSchema = metaData.getTableSchema();
        this.tableName = metaData.getTableName();
        this.schema = metaData.getSchema();
        this.truncate = metaData.getShouldTruncate();
        this.timeoutMilliseconds = metaData.getTimeoutMillis();
        this.status = MockTaskStatus.CREATED;
        this.handlers = new ArrayList();
        this.tableTasks = new ArrayList<AbstractMockTask>();
        this.threadName2WriteCount = new ConcurrentHashMap<String, Long>();
        this.threadName2GenerateCount = new ConcurrentHashMap<String, Long>();
    }

    public void appendHandle(Future<?> handle) {
        if (handle == null) {
            return;
        }
        if (MockTaskStatus.RUNNING.equals((Object)this.status)) {
            this.handlers.add(handle);
        }
    }

    public Long getTotalGenerateCount() {
        OptionalDouble optional = this.threadName2GenerateCount.values().stream().mapToLong(v -> v).average();
        if (!optional.isPresent()) {
            return 0L;
        }
        return Double.valueOf(optional.getAsDouble()).longValue();
    }

    public Long getTotalWriteCount() {
        return this.threadName2WriteCount.values().stream().mapToLong(v -> v).sum();
    }

    public Long getTotalWriteCountByCurrentThread() {
        Long value = this.threadName2WriteCount.get(Thread.currentThread().getName());
        return value == null ? 0L : value;
    }

    public void appendHandle(@NonNull List<AbstractMockTask> tableTasks) {
        if (tableTasks == null) {
            throw new NullPointerException("tableTasks is marked @NonNull but is null");
        }
        this.tableTasks.addAll(tableTasks);
    }

    public void appendHandle(@NonNull AbstractMockTask tableTask) {
        if (tableTask == null) {
            throw new NullPointerException("tableTask is marked @NonNull but is null");
        }
        this.tableTasks.add(tableTask);
    }

    public boolean shutdown() {
        this.status = MockTaskStatus.CANCELED;
        return this.terminate();
    }

    public synchronized boolean terminate() {
        this.shutdown = true;
        boolean returnVal = Boolean.TRUE;
        this.tableTasks.forEach(AbstractMockTask::cancel);
        for (Future<?> task : this.handlers) {
            if (task.isCancelled() || task.isDone()) continue;
            returnVal &= task.cancel(true);
        }
        return returnVal;
    }

    public long accumulateGenerateCountAndGet(long count) {
        String threadName = Thread.currentThread().getName();
        Long value = this.threadName2GenerateCount.get(threadName);
        value = value == null ? Long.valueOf(count) : Long.valueOf(value + count);
        this.threadName2GenerateCount.put(threadName, value);
        return this.threadName2GenerateCount.values().stream().mapToLong(v -> v).sum();
    }

    public long accumulateWriteCountAndGet(long count) {
        String threadName = Thread.currentThread().getName();
        Long value = this.threadName2WriteCount.get(threadName);
        value = value == null ? Long.valueOf(count) : Long.valueOf(value + count);
        this.threadName2WriteCount.put(threadName, value);
        return this.threadName2WriteCount.values().stream().mapToLong(v -> v).sum();
    }

    public synchronized void setStatus(MockTaskStatus status) {
        this.status = status;
    }

    public double getProgress() {
        if (this.totalCount != 0L && this.threadName2GenerateCount.size() != 0) {
            Collection<Long> values = this.threadName2GenerateCount.values();
            Iterator<Long> iter = values.iterator();
            double totalProgress = 0.0;
            while (iter.hasNext()) {
                Long value = iter.next();
                totalProgress += value.doubleValue() / (double)this.totalCount.longValue();
            }
            return totalProgress / (double)this.threadName2GenerateCount.size();
        }
        return 0.0;
    }

    public Long getBatchSize() {
        return this.batchSize;
    }

    public Long getTotalCount() {
        return this.totalCount;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchema() {
        return this.schema;
    }

    public Boolean getTruncate() {
        return this.truncate;
    }

    public Long getTimeoutMilliseconds() {
        return this.timeoutMilliseconds;
    }

    public Map<String, Long> getThreadName2WriteCount() {
        return this.threadName2WriteCount;
    }

    public Map<String, Long> getThreadName2GenerateCount() {
        return this.threadName2GenerateCount;
    }

    public int getTopIndex() {
        return this.topIndex;
    }

    public SqlScriptOutput getOutput() {
        return this.output;
    }

    public List<AbstractMockTask> getTableTasks() {
        return this.tableTasks;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public MockTaskStatus getStatus() {
        return this.status;
    }

    public Map<String, AbstractDataType<?, ? extends Comparable<?>>> getTableSchema() {
        return this.tableSchema;
    }
}

