/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.core.task;

import com.oceanbase.tools.datamocker.constraint.Constraint;
import com.oceanbase.tools.datamocker.core.DataSourceFactory;
import com.oceanbase.tools.datamocker.core.read.ColumnReader;
import com.oceanbase.tools.datamocker.core.task.TableTaskMetaData;
import com.oceanbase.tools.datamocker.core.write.DataWriter;
import com.oceanbase.tools.datamocker.core.write.SqlScriptOutput;
import com.oceanbase.tools.dbbrowser.util.SqlBuilder;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.NonNull;

public class TableTaskInfo {
    private final TableTaskMetaData metaData;
    private final List<DataWriter> dataWriters;
    private final List<ColumnReader<?>> columnReaders;
    private final List<Constraint> constraints;
    private final DataSourceFactory dataSourceFactory;
    private final SqlScriptOutput output;
    private final Supplier<SqlBuilder> sqlBuilderSupplier;

    public TableTaskInfo(@NonNull List<DataWriter> dataWriters, @NonNull List<ColumnReader<?>> columnReaders, @NonNull DataSourceFactory dataSourceFactory, @NonNull List<Constraint> constraints, @NonNull TableTaskMetaData metaData, @NonNull SqlScriptOutput output, @NonNull Supplier<SqlBuilder> sqlBuilderSupplier) {
        if (dataWriters == null) {
            throw new NullPointerException("dataWriters is marked @NonNull but is null");
        }
        if (columnReaders == null) {
            throw new NullPointerException("columnReaders is marked @NonNull but is null");
        }
        if (dataSourceFactory == null) {
            throw new NullPointerException("dataSourceFactory is marked @NonNull but is null");
        }
        if (constraints == null) {
            throw new NullPointerException("constraints is marked @NonNull but is null");
        }
        if (metaData == null) {
            throw new NullPointerException("metaData is marked @NonNull but is null");
        }
        if (output == null) {
            throw new NullPointerException("output is marked @NonNull but is null");
        }
        if (sqlBuilderSupplier == null) {
            throw new NullPointerException("sqlBuilderSupplier is marked @NonNull but is null");
        }
        this.columnReaders = columnReaders;
        this.constraints = constraints;
        this.metaData = metaData;
        this.dataWriters = dataWriters;
        this.dataSourceFactory = dataSourceFactory;
        this.output = output;
        this.sqlBuilderSupplier = sqlBuilderSupplier;
    }

    public Set<String> columnGroups() {
        return this.columnReaders.stream().map(ColumnReader::groupId).collect(Collectors.toSet());
    }

    public TableTaskMetaData getMetaData() {
        return this.metaData;
    }

    public List<DataWriter> getDataWriters() {
        return this.dataWriters;
    }

    public List<ColumnReader<?>> getColumnReaders() {
        return this.columnReaders;
    }

    public List<Constraint> getConstraints() {
        return this.constraints;
    }

    public DataSourceFactory getDataSourceFactory() {
        return this.dataSourceFactory;
    }

    public SqlScriptOutput getOutput() {
        return this.output;
    }

    public Supplier<SqlBuilder> getSqlBuilderSupplier() {
        return this.sqlBuilderSupplier;
    }
}

