/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.core.task;

import com.oceanbase.tools.datamocker.datatype.AbstractDataType;
import com.oceanbase.tools.datamocker.model.config.MockTableConfig;
import java.util.Map;
import lombok.NonNull;

public class TableTaskMetaData {
    private final Long totalCount;
    private final Map<String, AbstractDataType<?, ? extends Comparable<?>>> tableSchema;
    private final String tableName;
    private final String schema;
    private final Boolean shouldTruncate;
    private final Long timeoutMillis;
    private final Long batchSize;
    private final String logDir;
    private final int maxErrors;
    private final Integer concurrent;

    public TableTaskMetaData(@NonNull Map<String, AbstractDataType<?, ? extends Comparable<?>>> tableSchema, @NonNull MockTableConfig tableConfig, @NonNull String logDir) {
        if (tableSchema == null) {
            throw new NullPointerException("tableSchema is marked @NonNull but is null");
        }
        if (tableConfig == null) {
            throw new NullPointerException("tableConfig is marked @NonNull but is null");
        }
        if (logDir == null) {
            throw new NullPointerException("logDir is marked @NonNull but is null");
        }
        this.tableSchema = tableSchema;
        this.tableName = tableConfig.getTableName();
        this.schema = tableConfig.getSchemaName();
        this.shouldTruncate = tableConfig.getWhetherTruncate();
        this.timeoutMillis = tableConfig.getTimeoutMillis();
        this.batchSize = tableConfig.getMaxBatchSize();
        this.totalCount = tableConfig.getTotalCount();
        this.logDir = logDir;
        this.maxErrors = tableConfig.getMaxErrors();
        this.concurrent = tableConfig.getConcurrent();
    }

    public Long getTotalCount() {
        return this.totalCount;
    }

    public Map<String, AbstractDataType<?, ? extends Comparable<?>>> getTableSchema() {
        return this.tableSchema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchema() {
        return this.schema;
    }

    public Boolean getShouldTruncate() {
        return this.shouldTruncate;
    }

    public Long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public Long getBatchSize() {
        return this.batchSize;
    }

    public String getLogDir() {
        return this.logDir;
    }

    public int getMaxErrors() {
        return this.maxErrors;
    }

    public Integer getConcurrent() {
        return this.concurrent;
    }
}

