/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.core.write;

import com.oceanbase.tools.datamocker.core.DataSourceFactory;
import com.oceanbase.tools.datamocker.core.write.DataWriter;
import com.oceanbase.tools.datamocker.model.mock.MockRowData;
import com.oceanbase.tools.dbbrowser.util.SqlBuilder;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.sql.DataSource;
import lombok.NonNull;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;

public class JdbcWriter
implements DataWriter {
    private static final Logger log = LoggerFactory.getLogger(JdbcWriter.class);
    private final String tableName;
    private final String schema;
    private final DataSource dataSource;
    private final JdbcOperations jdbc;
    private final Supplier<SqlBuilder> sqlBuilderSupplier;
    private final Integer concurrent;
    private final ExecutorService executorService;
    private volatile boolean closed = false;

    public JdbcWriter(@NonNull DataSourceFactory dataSourceFactory, @NonNull Supplier<SqlBuilder> sqlBuilderSupplier, @NonNull Integer concurrent, @NonNull String schema, @NonNull String tableName) throws SQLException {
        if (dataSourceFactory == null) {
            throw new NullPointerException("dataSourceFactory is marked @NonNull but is null");
        }
        if (sqlBuilderSupplier == null) {
            throw new NullPointerException("sqlBuilderSupplier is marked @NonNull but is null");
        }
        if (concurrent == null) {
            throw new NullPointerException("concurrent is marked @NonNull but is null");
        }
        if (schema == null) {
            throw new NullPointerException("schema is marked @NonNull but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked @NonNull but is null");
        }
        this.tableName = tableName;
        this.schema = schema;
        this.dataSource = dataSourceFactory.generate();
        this.jdbc = new JdbcTemplate(this.dataSource);
        this.sqlBuilderSupplier = sqlBuilderSupplier;
        this.concurrent = concurrent;
        this.executorService = this.getThreadPoolExecutor();
    }

    @Override
    public long write(List<MockRowData> rows) {
        int i;
        if (this.closed) {
            throw new IllegalStateException("JdbcWriter has been closed");
        }
        SqlBuilder sqlBuilder = this.sqlBuilderSupplier.get().append((CharSequence)"INSERT INTO ").identifier(this.schema).append((CharSequence)".").identifier(this.tableName).append((CharSequence)" (");
        ArrayList<String> columnList = new ArrayList<String>(rows.get(0).columnNames());
        int columnLength = columnList.size();
        for (i = 0; i < columnLength; ++i) {
            sqlBuilder.identifier((String)columnList.get(i));
            if (i >= columnLength - 1) continue;
            sqlBuilder.append((CharSequence)", ");
        }
        sqlBuilder.append((CharSequence)") VALUES (");
        for (i = 0; i < columnLength; ++i) {
            sqlBuilder.append((CharSequence)"?");
            if (i >= columnLength - 1) continue;
            sqlBuilder.append((CharSequence)", ");
        }
        String sql = sqlBuilder.append((CharSequence)")").toString();
        int size = rows.size() / this.concurrent;
        if (rows.size() % this.concurrent != 0) {
            ++size;
        }
        List lists = ListUtils.partition(rows, (int)size);
        ExecutorCompletionService<Integer> completionService = new ExecutorCompletionService<Integer>(this.executorService);
        for (int i2 = 1; i2 < lists.size(); ++i2) {
            List mockRowData = (List)lists.get(i2);
            completionService.submit(() -> this.doWrite(sql, columnList, mockRowData));
        }
        Integer totalAffectRows = 0;
        try {
            totalAffectRows = totalAffectRows + this.doWrite(sql, columnList, (List)lists.get(0));
        }
        catch (Exception e) {
            log.warn("Failed to write jdbc, message={}", (Object)e.getMessage());
            throw new IllegalStateException(e);
        }
        for (int i3 = 1; i3 < lists.size(); ++i3) {
            try {
                totalAffectRows = totalAffectRows + (Integer)completionService.take().get();
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                log.warn("Failed to write jdbc, message={}", (Object)e.getMessage());
                throw new IllegalStateException(e);
            }
        }
        return totalAffectRows.longValue();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws Exception {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        try {
            this.executorService.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.dataSource instanceof AutoCloseable) {
            ((AutoCloseable)((Object)this.dataSource)).close();
        }
        log.info("JdbcWriter has been closed, concurrent={}", (Object)this.concurrent);
    }

    private ThreadPoolExecutor getThreadPoolExecutor() {
        int corePoolSize = Math.max(Runtime.getRuntime().availableProcessors(), 5);
        return new ThreadPoolExecutor(corePoolSize, corePoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("ob-data-mocker-writer-thread-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    private int doWrite(String sql, final List<String> columnList, final List<MockRowData> mockRowData) {
        final int columnLength = columnList.size();
        int[] affectRows = this.jdbc.batchUpdate(sql, new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return mockRowData.size();
            }

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                MockRowData row = (MockRowData)mockRowData.get(i);
                for (int j = 0; j < columnLength; ++j) {
                    ps.setObject(j + 1, row.getMockColumn((String)columnList.get(j)).getJdbcColumnValue());
                }
            }
        });
        return Arrays.stream(affectRows).map(value -> {
            switch (value) {
                case -3: {
                    throw new IllegalStateException("Failed to execute a batch");
                }
                case -2: {
                    return 1;
                }
            }
            return value;
        }).sum();
    }
}

