/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.core.write;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlScriptOutput
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(SqlScriptOutput.class);
    private final File outputDir;
    private final Long maxSingleFileInByte;
    private final String tableName;
    private Integer counter = 0;
    private AtomicLong totalWriteBytes = new AtomicLong(0L);
    private FileOutputStreamWrapper currentOutput;

    public SqlScriptOutput(@NonNull File outputDir, @NonNull String tableName, @NonNull Long maxSingleFileInBytes) throws IOException {
        if (outputDir == null) {
            throw new NullPointerException("outputDir is marked @NonNull but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked @NonNull but is null");
        }
        if (maxSingleFileInBytes == null) {
            throw new NullPointerException("maxSingleFileInBytes is marked @NonNull but is null");
        }
        Validate.isTrue((maxSingleFileInBytes > 0L ? 1 : 0) != 0);
        Validate.isTrue((outputDir.isDirectory() && outputDir.exists() ? 1 : 0) != 0);
        this.tableName = tableName;
        this.outputDir = outputDir;
        this.maxSingleFileInByte = maxSingleFileInBytes;
        this.currentOutput = this.createNewOutputStream();
    }

    public OutputStream getOutputStream() {
        if (this.currentOutput.getTotalWriteBytes() >= this.maxSingleFileInByte) {
            try {
                FileOutputStreamWrapper old = this.currentOutput;
                this.currentOutput = this.createNewOutputStream();
                old.close();
            }
            catch (Exception e) {
                log.warn("Failed to create a new file, message={}", (Object)e.getMessage());
            }
        }
        return this.currentOutput;
    }

    public Long getTotalWriteBytes() {
        return this.totalWriteBytes.get();
    }

    public static void toZip(@NonNull File target, @NonNull File workingDir) throws IOException {
        File[] files;
        if (target == null) {
            throw new NullPointerException("target is marked @NonNull but is null");
        }
        if (workingDir == null) {
            throw new NullPointerException("workingDir is marked @NonNull but is null");
        }
        File parentDir = target.getParentFile();
        if (!parentDir.exists()) {
            FileUtils.forceMkdir((File)parentDir);
        }
        if ((files = workingDir.listFiles()) == null) {
            throw new IllegalStateException("Nothing to zip, " + workingDir.getAbsolutePath());
        }
        try (FileOutputStream outputStream = new FileOutputStream(target);
             ZipArchiveOutputStream out = new ZipArchiveOutputStream((OutputStream)outputStream);){
            for (File file : files) {
                if (file.isDirectory()) {
                    File[] subFiles = file.listFiles();
                    if (subFiles == null || Arrays.stream(subFiles).noneMatch(f -> f.isFile() && StringUtils.endsWithIgnoreCase((CharSequence)f.getName(), (CharSequence)".sql"))) continue;
                    String dirName = file.getName();
                    out.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(dirName + "/"));
                    out.closeArchiveEntry();
                    for (File subFile : subFiles) {
                        if (!subFile.isFile() || StringUtils.equalsIgnoreCase((CharSequence)subFile.getName(), (CharSequence)".sql")) continue;
                        out.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(dirName + "/" + subFile.getName()));
                        try (FileInputStream inputStream = new FileInputStream(subFile);){
                            IOUtils.copy((InputStream)inputStream, (OutputStream)out);
                        }
                        out.closeArchiveEntry();
                    }
                    continue;
                }
                if (!file.isFile() || !StringUtils.endsWithIgnoreCase((CharSequence)file.getName(), (CharSequence)".sql")) continue;
                out.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(file.getName()));
                try (FileInputStream inputStream = new FileInputStream(file);){
                    IOUtils.copy((InputStream)inputStream, (OutputStream)out);
                }
                out.closeArchiveEntry();
            }
            out.flush();
        }
        if (!target.exists()) {
            throw new IllegalStateException("Failed to create a zip file");
        }
    }

    @Override
    public void close() throws Exception {
        this.currentOutput.close();
    }

    private FileOutputStreamWrapper createNewOutputStream() throws IOException {
        SqlScriptOutput sqlScriptOutput = this;
        Integer n = sqlScriptOutput.counter;
        Integer n2 = sqlScriptOutput.counter = Integer.valueOf(sqlScriptOutput.counter + 1);
        String fileName = this.tableName + "_" + n + ".sql";
        File target = new File(this.outputDir, fileName);
        if (!target.createNewFile()) {
            throw new IllegalStateException("Fail to create file, " + target.getName());
        }
        return new FileOutputStreamWrapper(target, true, this.totalWriteBytes);
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    private static class FileOutputStreamWrapper
    extends FileOutputStream {
        private final AtomicLong totalOutputSize;
        private Long totalWriteBytes = 0L;

        public FileOutputStreamWrapper(File file, boolean append, AtomicLong totalOutputSize) throws FileNotFoundException {
            super(file, append);
            this.totalOutputSize = totalOutputSize;
        }

        @Override
        public void write(int b) throws IOException {
            super.write(b);
            FileOutputStreamWrapper fileOutputStreamWrapper = this;
            Long l = fileOutputStreamWrapper.totalWriteBytes;
            Long l2 = fileOutputStreamWrapper.totalWriteBytes = Long.valueOf(fileOutputStreamWrapper.totalWriteBytes + 1L);
            this.totalOutputSize.incrementAndGet();
        }

        @Override
        public void write(byte[] b) throws IOException {
            super.write(b);
            FileOutputStreamWrapper fileOutputStreamWrapper = this;
            fileOutputStreamWrapper.totalWriteBytes = fileOutputStreamWrapper.totalWriteBytes + (long)b.length;
            this.totalOutputSize.addAndGet(b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            super.write(b, off, len);
            FileOutputStreamWrapper fileOutputStreamWrapper = this;
            fileOutputStreamWrapper.totalWriteBytes = fileOutputStreamWrapper.totalWriteBytes + (long)len;
            this.totalOutputSize.addAndGet(len);
        }

        public AtomicLong getTotalOutputSize() {
            return this.totalOutputSize;
        }

        public Long getTotalWriteBytes() {
            return this.totalWriteBytes;
        }
    }
}

