/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.core.write;

import com.oceanbase.tools.datamocker.core.write.DataWriter;
import com.oceanbase.tools.datamocker.core.write.SqlScriptOutput;
import com.oceanbase.tools.datamocker.model.mock.MockColumnData;
import com.oceanbase.tools.datamocker.model.mock.MockRowData;
import com.oceanbase.tools.dbbrowser.util.SqlBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlScriptWriter
implements DataWriter {
    private static final Logger log = LoggerFactory.getLogger(SqlScriptWriter.class);
    private final String tableName;
    private final String schema;
    private final SqlScriptOutput output;
    private final Long maxOutputSizeInBytes;
    private final Supplier<SqlBuilder> sqlBuilderSupplier;
    private volatile boolean closed = false;

    public SqlScriptWriter(@NonNull SqlScriptOutput output, @NonNull Long maxOutputSizeInBytes, @NonNull Supplier<SqlBuilder> sqlBuilderSupplier, @NonNull String schema, @NonNull String tableName) {
        if (output == null) {
            throw new NullPointerException("output is marked @NonNull but is null");
        }
        if (maxOutputSizeInBytes == null) {
            throw new NullPointerException("maxOutputSizeInBytes is marked @NonNull but is null");
        }
        if (sqlBuilderSupplier == null) {
            throw new NullPointerException("sqlBuilderSupplier is marked @NonNull but is null");
        }
        if (schema == null) {
            throw new NullPointerException("schema is marked @NonNull but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked @NonNull but is null");
        }
        this.tableName = tableName;
        this.schema = schema;
        this.output = output;
        this.maxOutputSizeInBytes = maxOutputSizeInBytes <= 0L ? Long.MAX_VALUE : maxOutputSizeInBytes;
        this.sqlBuilderSupplier = sqlBuilderSupplier;
    }

    @Override
    public long write(List<MockRowData> rows) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("SqlScriptWriter has been closed");
        }
        if (this.output.getTotalWriteBytes() >= this.maxOutputSizeInBytes) {
            return 0L;
        }
        SqlBuilder prefixBuilder = this.sqlBuilderSupplier.get();
        prefixBuilder.append((CharSequence)"INSERT INTO ").identifier(this.schema).append((CharSequence)".").identifier(this.tableName).append((CharSequence)" (");
        ArrayList<String> columnList = new ArrayList<String>(rows.get(0).columnNames());
        int columnLength = columnList.size();
        for (int i = 0; i < columnLength; ++i) {
            prefixBuilder.identifier((String)columnList.get(i));
            if (i >= columnLength - 1) continue;
            prefixBuilder.append((CharSequence)", ");
        }
        String prefix = prefixBuilder.append((CharSequence)") VALUES (").toString();
        StringBuilder sqlStringBuilder = new StringBuilder();
        rows.forEach(rowData -> {
            SqlBuilder sqlBuilder = this.sqlBuilderSupplier.get().append((CharSequence)prefix);
            for (int i = 0; i < columnLength; ++i) {
                String columnName = (String)columnList.get(i);
                MockColumnData<?> mockColumn = rowData.getMockColumn(columnName);
                String value = mockColumn.getColumnValueString();
                if (value == null) {
                    throw new IllegalStateException(String.format("Value for column \"%s\" is null", columnName));
                }
                sqlBuilder.append((CharSequence)value);
                if (i == columnLength - 1) {
                    sqlBuilder.append((CharSequence)");");
                    continue;
                }
                sqlBuilder.append((CharSequence)", ");
            }
            sqlStringBuilder.append(sqlBuilder.toString()).append("\n");
        });
        byte[] buffer = sqlStringBuilder.toString().getBytes();
        IOUtils.write((byte[])buffer, (OutputStream)this.output.getOutputStream());
        return buffer.length;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws Exception {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        this.output.close();
        log.info("SqlScriptWriter has been closed");
    }
}

