/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.datatype;

import com.oceanbase.tools.datamocker.datatype.AbstractDataType;
import com.oceanbase.tools.datamocker.generator.BaseDateGenerator;
import com.oceanbase.tools.datamocker.model.enums.ObModeType;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import java.util.TimeZone;

public abstract class AbstractDateDataType<T extends Comparable<? super T>>
extends AbstractDataType<T, T> {
    private TimeZone timeZone = TimeZone.getDefault();

    public AbstractDateDataType(BaseDateGenerator<T> generator, ObModeType dialectType, T defaultValue, Boolean allowNull) {
        super(generator, dialectType, defaultValue, allowNull);
    }

    protected AbstractDateDataType(ObModeType dialectType, T defaultValue, Boolean allowNull) {
        super(dialectType, defaultValue, allowNull);
    }

    protected AbstractDateDataType(ObModeType dialectType, TimeZone timeZone, T defaultValue, Boolean allowNull) {
        super(dialectType, defaultValue, allowNull);
        this.timeZone = timeZone;
    }

    protected abstract Long limitForType(T var1, T var2);

    @Override
    public Long distinctLimit() {
        if (this.generator == null || this.generator.count(this.lowValue(), this.highValue()) == null) {
            return this.limitForType(this.lowValue(), this.highValue());
        }
        return this.limitForType(this.lowValue(), this.highValue()) < this.generator.count(this.lowValue(), this.highValue()) ? this.limitForType(this.lowValue(), this.highValue()) : this.generator.count(this.lowValue(), this.highValue());
    }

    @Override
    protected T preProcessingBeforeOutput(T value) {
        if (value == null) {
            return null;
        }
        if (value.compareTo(this.lowValue()) < 0) {
            throw new MockerException(MockerError.ILLEGAL_RETURN_VALUE, "Date can not be smaller than low value");
        }
        if (value.compareTo(this.highValue()) > 0) {
            throw new MockerException(MockerError.ILLEGAL_RETURN_VALUE, "Date can not be bigger than high value");
        }
        return (T)value;
    }

    @Override
    public synchronized String convertToSqlString(T value) {
        return this.convertToSqlString(value, this.timeZone);
    }

    protected abstract String convertToSqlString(T var1, TimeZone var2);

    @Override
    public T toDigest(T value) {
        return value;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }
}

