/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.datatype.mysql;

import com.oceanbase.tools.datamocker.datatype.AbstractByteDataType;
import com.oceanbase.tools.datamocker.datatype.DataTypeFactory;
import com.oceanbase.tools.datamocker.generator.BaseByteGenerator;
import com.oceanbase.tools.datamocker.model.config.CharDataTypeConfig;
import com.oceanbase.tools.datamocker.model.enums.ObModeType;

public class MysqlBinaryType
extends AbstractByteDataType {
    private final Integer width;

    public MysqlBinaryType(byte[] defaultValue, Boolean allowNull, Integer width, BaseByteGenerator generator) {
        super(generator, ObModeType.OB_MYSQL, defaultValue, allowNull);
        this.width = width;
    }

    public MysqlBinaryType(byte[] defaultValue, Boolean allowNull, Integer width) {
        super(ObModeType.OB_MYSQL, defaultValue, allowNull);
        this.width = width;
    }

    @Override
    public DataTypeFactory<MysqlBinaryType, CharDataTypeConfig, BaseByteGenerator> getFactory() {
        return DataTypeFactory.getInstance("OB_MYSQL_BINARY");
    }

    @Override
    protected Integer maxValueForType() {
        return this.width;
    }

    @Override
    public String convertToSqlString(byte[] value) {
        if (value == null) {
            return "NULL";
        }
        return String.format("'%s'", new String(value));
    }

    public String toString() {
        return String.format("BINARY(%d)", this.width);
    }
}

