/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.datatype.mysql;

import com.oceanbase.tools.datamocker.datatype.AbstractDigitDataType;
import com.oceanbase.tools.datamocker.datatype.DataTypeFactory;
import com.oceanbase.tools.datamocker.datatype.mysql.MysqlIntType;
import com.oceanbase.tools.datamocker.generator.BaseDigitalGenerator;
import com.oceanbase.tools.datamocker.model.config.DigitDataTypeConfig;
import com.oceanbase.tools.datamocker.model.enums.ObModeType;
import java.math.BigDecimal;
import org.apache.commons.lang3.Validate;

public class MysqlBitType
extends AbstractDigitDataType<BigDecimal> {
    private final int bitLength;

    public MysqlBitType(int bitLength, BaseDigitalGenerator<BigDecimal> generator, BigDecimal defaultValue, Boolean allowNull) {
        super(generator, ObModeType.OB_MYSQL, defaultValue, allowNull, false);
        Validate.inclusiveBetween((long)1L, (long)64L, (long)bitLength, (String)"Bit length is out of range [1-64]");
        this.bitLength = bitLength;
    }

    @Override
    public BigDecimal convertFromJdbcObjectToJavaObject(Object value) {
        return value == null ? null : new BigDecimal(value.toString());
    }

    @Override
    public DataTypeFactory<MysqlIntType, DigitDataTypeConfig, BaseDigitalGenerator<BigDecimal>> getFactory() {
        return DataTypeFactory.getInstance("OB_MYSQL_BIT");
    }

    public String toString() {
        return "bit";
    }

    @Override
    public String convertToSqlString(BigDecimal value) {
        return value == null ? "NULL" : value.toPlainString();
    }

    @Override
    protected BigDecimal minValueForType() {
        return new BigDecimal("0");
    }

    @Override
    protected BigDecimal maxValueForType() {
        return new BigDecimal("2").pow(this.bitLength).subtract(new BigDecimal("1"));
    }

    @Override
    protected BigDecimal preProcessingBeforeOutput(BigDecimal value) {
        return value == null ? null : value.setScale(0, 1);
    }

    @Override
    protected Long limitForType(BigDecimal lowValue, BigDecimal highValue) {
        return Long.parseLong(highValue.subtract(lowValue).toPlainString()) + 1L;
    }
}

