/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.datatype.mysql;

import com.oceanbase.tools.datamocker.datatype.AbstractByteDataType;
import com.oceanbase.tools.datamocker.datatype.DataTypeFactory;
import com.oceanbase.tools.datamocker.generator.BaseByteGenerator;
import com.oceanbase.tools.datamocker.model.config.CharDataTypeConfig;
import com.oceanbase.tools.datamocker.model.enums.ObModeType;

public class MysqlBlobType
extends AbstractByteDataType {
    private final Integer length;

    public MysqlBlobType(Integer length, byte[] defaultValue, Boolean allowNull, BaseByteGenerator generator) {
        super(generator, ObModeType.OB_MYSQL, defaultValue, allowNull);
        this.length = length;
    }

    public MysqlBlobType(Integer length, byte[] defaultValue, Boolean allowNull) {
        super(ObModeType.OB_MYSQL, defaultValue, allowNull);
        this.length = length;
    }

    @Override
    public DataTypeFactory<MysqlBlobType, CharDataTypeConfig, BaseByteGenerator> getFactory() {
        return DataTypeFactory.getInstance("OB_MYSQL_BLOB");
    }

    @Override
    protected Integer maxValueForType() {
        return this.length;
    }

    @Override
    public String convertToSqlString(byte[] value) {
        if (value == null) {
            return "NULL";
        }
        return String.format("'%s'", new String(value));
    }

    public String toString() {
        return "BLOB";
    }
}

