/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.datatype.mysql;

import com.oceanbase.tools.datamocker.datatype.AbstractDigitDataType;
import com.oceanbase.tools.datamocker.datatype.DataTypeFactory;
import com.oceanbase.tools.datamocker.generator.BaseDigitalGenerator;
import com.oceanbase.tools.datamocker.model.config.DigitDataTypeConfig;
import com.oceanbase.tools.datamocker.model.enums.ObModeType;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import java.math.BigDecimal;

public class MysqlDecimalType
extends AbstractDigitDataType<BigDecimal> {
    private final int precision;
    private final int scale;

    public MysqlDecimalType(int precision, int scale, BaseDigitalGenerator<BigDecimal> generator, BigDecimal defaultValue, Boolean allowNull, Boolean signed) {
        super(generator, ObModeType.OB_MYSQL, defaultValue, allowNull, signed);
        this.validate(precision, scale);
        this.precision = precision;
        this.scale = scale;
    }

    public MysqlDecimalType(BaseDigitalGenerator<BigDecimal> generator, BigDecimal defaultValue, Boolean allowNull, Boolean signed) {
        super(generator, ObModeType.OB_MYSQL, defaultValue, allowNull, signed);
        this.precision = 10;
        this.scale = 0;
    }

    private void validate(int precision, int scale) {
        if (precision <= 0 || precision > 65) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Precision for decaimal can not larger than 65 or smaller than 0");
        }
        if (scale < 0 || scale > 30) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Scale for decimal can not larger than 30 or smaller than 0");
        }
        if (precision < scale) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Scale can not be bigger than precision");
        }
    }

    @Override
    protected BigDecimal maxValueForType() {
        return this.maxOrMinForNumber();
    }

    @Override
    protected BigDecimal minValueForType() {
        if (this.signed().booleanValue()) {
            return this.maxOrMinForNumber().multiply(new BigDecimal(-1));
        }
        return new BigDecimal("0");
    }

    @Override
    protected Long limitForType(BigDecimal lowValue, BigDecimal highValue) {
        BigDecimal interval = highValue.subtract(lowValue);
        BigDecimal result = interval.multiply(new BigDecimal(Double.toString(Math.pow(10.0, this.scale)))).setScale(0, 1);
        return Long.valueOf(result.toPlainString());
    }

    @Override
    protected BigDecimal preProcessingBeforeOutput(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return value.setScale(this.scale, 5);
    }

    @Override
    public String convertToSqlString(BigDecimal value) {
        if (value == null) {
            return "NULL";
        }
        return value.setScale(this.scale, 5).toPlainString();
    }

    public String toString() {
        return String.format("decimal(%d, %d)", this.precision, this.scale);
    }

    private BigDecimal maxOrMinForNumber() {
        BigDecimal secondPartMaxValue;
        this.validate(this.precision, this.scale);
        int interval = this.precision - this.scale;
        int firstPartWidth = Math.max(interval, 0);
        BigDecimal firstPartMaxValue = new BigDecimal(Double.toString(Math.pow(10.0, firstPartWidth))).subtract(BigDecimal.ONE);
        BigDecimal factor = new BigDecimal(Double.toString(Math.pow(10.0, -this.scale - 1)));
        if (this.scale >= 0) {
            if (firstPartWidth > 0) {
                factor = factor.multiply(new BigDecimal(5));
                secondPartMaxValue = BigDecimal.ONE.subtract(new BigDecimal(Double.toString(Math.pow(10.0, -this.scale)))).add(factor);
            } else {
                factor = factor.multiply(new BigDecimal(4));
                secondPartMaxValue = new BigDecimal(Double.toString(Math.pow(10.0, interval))).subtract(new BigDecimal(Double.toString(Math.pow(10.0, -this.scale)))).add(factor);
            }
        } else {
            factor = factor.multiply(new BigDecimal(5));
            firstPartMaxValue = firstPartMaxValue.subtract(factor);
            secondPartMaxValue = BigDecimal.ZERO;
        }
        return firstPartMaxValue.add(secondPartMaxValue);
    }

    @Override
    public DataTypeFactory<MysqlDecimalType, DigitDataTypeConfig, BaseDigitalGenerator<BigDecimal>> getFactory() {
        if (this.signed().booleanValue()) {
            return DataTypeFactory.getInstance("OB_MYSQL_DECIMAL");
        }
        return DataTypeFactory.getInstance("OB_MYSQL_DECIMAL_UNSIGNED");
    }
}

