/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.datatype.mysql;

import com.oceanbase.tools.datamocker.datatype.AbstractDigitDataType;
import com.oceanbase.tools.datamocker.datatype.DataTypeFactory;
import com.oceanbase.tools.datamocker.generator.BaseDigitalGenerator;
import com.oceanbase.tools.datamocker.model.config.DigitDataTypeConfig;
import com.oceanbase.tools.datamocker.model.enums.ObModeType;
import java.math.BigDecimal;

public class MysqlTinyIntType
extends AbstractDigitDataType<BigDecimal> {
    public MysqlTinyIntType(BaseDigitalGenerator<BigDecimal> generator, BigDecimal defaultValue, Boolean allowNull, Boolean signed) {
        super(generator, ObModeType.OB_MYSQL, defaultValue, allowNull, signed);
    }

    @Override
    protected Long limitForType(BigDecimal lowValue, BigDecimal highValue) {
        BigDecimal interval = highValue.subtract(lowValue);
        return Long.parseLong(interval.toPlainString()) + 1L;
    }

    @Override
    public BigDecimal convertFromJdbcObjectToJavaObject(Object value) {
        if (value == null) {
            return null;
        }
        return new BigDecimal(value.toString());
    }

    @Override
    public DataTypeFactory<MysqlTinyIntType, DigitDataTypeConfig, BaseDigitalGenerator<BigDecimal>> getFactory() {
        if (this.signed().booleanValue()) {
            return DataTypeFactory.getInstance("OB_MYSQL_TINYINT");
        }
        return DataTypeFactory.getInstance("OB_MYSQL_TINYINT_UNSIGNED");
    }

    @Override
    protected BigDecimal minValueForType() {
        if (this.signed().booleanValue()) {
            return new BigDecimal("-128");
        }
        return new BigDecimal("0");
    }

    @Override
    protected BigDecimal maxValueForType() {
        if (this.signed().booleanValue()) {
            return new BigDecimal("127");
        }
        return new BigDecimal("255");
    }

    @Override
    protected BigDecimal preProcessingBeforeOutput(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return value.setScale(0, 1);
    }

    public String toString() {
        if (this.signed().booleanValue()) {
            return "tinyint";
        }
        return "tinyint unsigned";
    }

    @Override
    public String convertToSqlString(BigDecimal value) {
        if (value == null) {
            return "NULL";
        }
        return value.toPlainString();
    }
}

