/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.datatype.oracle;

import com.oceanbase.tools.datamocker.datatype.AbstractByteDataType;
import com.oceanbase.tools.datamocker.datatype.DataTypeFactory;
import com.oceanbase.tools.datamocker.generator.BaseByteGenerator;
import com.oceanbase.tools.datamocker.model.config.CharDataTypeConfig;
import com.oceanbase.tools.datamocker.model.enums.ObModeType;

public class OracleBlobType
extends AbstractByteDataType {
    public OracleBlobType(byte[] defaultValue, Boolean allowNull, BaseByteGenerator generator) {
        super(generator, ObModeType.OB_ORACLE, defaultValue, allowNull);
    }

    public OracleBlobType(byte[] defaultValue, Boolean allowNull) {
        super(ObModeType.OB_ORACLE, defaultValue, allowNull);
    }

    @Override
    public DataTypeFactory<OracleBlobType, CharDataTypeConfig, BaseByteGenerator> getFactory() {
        return DataTypeFactory.getInstance("OB_ORACLE_BLOB");
    }

    @Override
    protected Integer maxValueForType() {
        return 4096;
    }

    @Override
    public String convertToSqlString(byte[] value) {
        if (value == null) {
            return "NULL";
        }
        return String.format("utl_raw.cast_to_raw('%s')", new String(value));
    }

    public String toString() {
        return "BLOB";
    }
}

