/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.datatype.oracle;

import com.oceanbase.jdbc.extend.datatype.INTERVALYM;
import com.oceanbase.tools.datamocker.datatype.AbstractDataType;
import com.oceanbase.tools.datamocker.datatype.DataTypeFactory;
import com.oceanbase.tools.datamocker.generator.BaseGenerator;
import com.oceanbase.tools.datamocker.model.config.DateDataTypeConfig;
import com.oceanbase.tools.datamocker.model.enums.ObModeType;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;

public class OracleIntervalYMType
extends AbstractDataType<INTERVALYM, Integer> {
    private final Integer scale;

    public OracleIntervalYMType(BaseGenerator<Integer, INTERVALYM> generator, Integer scale, INTERVALYM defaultValue, Boolean allowNull) {
        super(generator, ObModeType.OB_ORACLE, defaultValue, allowNull);
        if (scale == null) {
            this.scale = 2;
        } else {
            if (scale > 9 || scale < 0) {
                throw new MockerException(MockerError.PARAMETER_ERROR, "Scale for inter year to month can not be larger than 9 or smaller than 0");
            }
            this.scale = scale;
        }
    }

    @Override
    public DataTypeFactory<OracleIntervalYMType, DateDataTypeConfig, BaseGenerator<Integer, INTERVALYM>> getFactory() {
        return DataTypeFactory.getInstance("OB_ORACLE_INTERVAL_YEAR_TO_MONTH");
    }

    @Override
    protected Integer minValueForType() {
        return 1;
    }

    @Override
    protected Integer maxValueForType() {
        return this.scale;
    }

    @Override
    public Long distinctLimit() {
        if (this.generator == null || this.generator.count(this.lowValue(), this.highValue()) == null) {
            return Long.MAX_VALUE;
        }
        return this.generator.count(this.lowValue(), this.highValue());
    }

    @Override
    protected INTERVALYM preProcessingBeforeOutput(INTERVALYM value) {
        if (value == null) {
            return null;
        }
        byte yearLen = value.getBytes()[value.getBytes().length - 1];
        if (yearLen > this.scale) {
            throw new MockerException(MockerError.VALUE_OUT_OFRANGE, String.format("Scale for interval year(%d) to month is out of bound, [%d>%d]", this.scale, yearLen, this.scale));
        }
        return value;
    }

    @Override
    public String convertToSqlString(INTERVALYM value) {
        if (value == null) {
            return "NULL";
        }
        return String.format("interval %s year to month", value.toString());
    }

    public String toString() {
        return String.format("INTERVAL YEAR(%d) TO MONTH", this.scale);
    }

    @Override
    public INTERVALYM toDigest(INTERVALYM value) {
        return value;
    }
}

